/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.browser;

import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.browser.BrowserException;
import cz.etnetera.seleniumbrowser.browser.BrowserUtils;
import cz.etnetera.seleniumbrowser.configuration.BasicBrowserConfiguration;
import cz.etnetera.seleniumbrowser.configuration.BrowserConfiguration;
import cz.etnetera.seleniumbrowser.configuration.BrowserConfigurationConstructException;
import cz.etnetera.seleniumbrowser.context.VerificationException;
import cz.etnetera.seleniumbrowser.element.BrowserElement;
import cz.etnetera.seleniumbrowser.element.BrowserElementConstructException;
import cz.etnetera.seleniumbrowser.element.BrowserElementLoader;
import cz.etnetera.seleniumbrowser.element.BrowserFieldDecorator;
import cz.etnetera.seleniumbrowser.event.BrowserEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterBrowserQuitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeBrowserQuitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeDriverConstructEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnFileSaveEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnReportEvent;
import cz.etnetera.seleniumbrowser.listener.BrowserListener;
import cz.etnetera.seleniumbrowser.listener.EventConstructException;
import cz.etnetera.seleniumbrowser.listener.EventFiringBrowserBridgeListener;
import cz.etnetera.seleniumbrowser.logic.Logic;
import cz.etnetera.seleniumbrowser.logic.LogicConstructException;
import cz.etnetera.seleniumbrowser.page.Page;
import cz.etnetera.seleniumbrowser.page.PageConstructException;
import cz.etnetera.seleniumbrowser.source.DataSource;
import cz.etnetera.seleniumbrowser.source.PropertySource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.DefaultElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class Browser
implements BrowserContext {
    public static final String PROPERTIES_CONFIGURATION_KEY = "properties";
    public static final String DEFAULT_CONFIGURATION_KEY = "default";
    public static final String LABEL_DELIMITER = "-";
    public static final DateTimeFormatter FILE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    protected BrowserConfiguration configuration;
    protected WebDriver driver;
    protected String baseUrl;
    protected String baseUrlRegex;
    protected boolean urlVerification;
    protected double waitTimeout;
    protected double waitRetryInterval;
    protected Page page;
    protected String label;
    protected boolean reported;
    protected File reportDir;
    protected List<BrowserListener> listeners;
    protected Map<String, Object> dataHolder = new HashMap<String, Object>();
    protected BrowserUtils utils = new BrowserUtils();
    protected BrowserElementLoader elementLoader = new BrowserElementLoader();
    protected JavascriptLibrary javascriptLibrary = new JavascriptLibrary();

    public Browser() {
        this.initDefault();
    }

    public <T extends BrowserConfiguration> Browser(Class<T> configCls) {
        this.init(configCls);
    }

    public Browser(BrowserConfiguration configuration) {
        this.init(configuration);
    }

    protected void initDefault() {
        this.init(BasicBrowserConfiguration.class);
    }

    protected <T extends BrowserConfiguration> void init(Class<T> configCls) {
        try {
            this.init((BrowserConfiguration)configCls.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new BrowserConfigurationConstructException("Unable to construct browser configuration " + configCls.getName(), e);
        }
    }

    protected void init(BrowserConfiguration configuration) {
        this.applyConfiguration(configuration);
        this.initListeners();
        this.driver = this.createDriver();
    }

    protected void applyConfiguration(BrowserConfiguration configuration) {
        configuration.init();
        this.configuration = configuration;
        this.baseUrl = configuration.getBaseUrl();
        this.baseUrlRegex = configuration.getBaseUrlRegex();
        this.urlVerification = configuration.isUrlVerification();
        this.waitTimeout = configuration.getWaitTimeout();
        this.waitRetryInterval = configuration.getWaitRetryInterval();
        this.reported = configuration.isReported();
        this.reportDir = configuration.getReportDir();
        if (this.reported) {
            if (this.reportDir == null) {
                throw new BrowserException("Report directory is null");
            }
            if (!this.reportDir.exists()) {
                try {
                    Files.createDirectories(this.reportDir.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new BrowserException("Report directory does not exists and can not be created " + this.reportDir);
                }
            } else {
                if (!this.reportDir.isDirectory()) {
                    throw new BrowserException("Report directory is not directory " + this.reportDir);
                }
                if (!this.reportDir.canWrite()) {
                    throw new BrowserException("Report directory is not writable " + this.reportDir);
                }
            }
        }
        if (configuration instanceof DataSource) {
            this.dataHolder = ((DataSource)((Object)configuration)).getDataHolder();
        }
        this.listeners = configuration.getListeners();
        if (this.listeners == null) {
            this.listeners = new ArrayList<BrowserListener>();
        }
    }

    protected void initListeners() {
        if (this.listeners != null) {
            this.listeners.forEach(l -> l.init(this));
        }
    }

    protected WebDriver createDriver() {
        DesiredCapabilities caps = this.configuration.getCapabilities();
        BeforeDriverConstructEvent befDriverConstEvent = this.constructEvent(BeforeDriverConstructEvent.class).with(caps);
        this.triggerEvent(befDriverConstEvent);
        EventFiringWebDriver drv = new EventFiringWebDriver(this.configuration.getDriver(befDriverConstEvent.getCapabilities()));
        drv.register((WebDriverEventListener)new EventFiringBrowserBridgeListener(this));
        return drv;
    }

    public void addListener(BrowserListener listener) {
        listener.init(this);
        this.listeners.add(listener);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabel(String ... labels) {
        this.label = this.utils.join(LABEL_DELIMITER, labels);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrlRegex() {
        return this.baseUrlRegex;
    }

    public void setBaseUrlRegex(String baseUrlRegex) {
        this.baseUrlRegex = baseUrlRegex;
    }

    public boolean isUrlVerification() {
        return this.urlVerification;
    }

    public void setUrlVerification(boolean urlVerification) {
        this.urlVerification = urlVerification;
    }

    @Override
    public double getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(double waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    @Override
    public double getWaitRetryInterval() {
        return this.waitRetryInterval;
    }

    public void setWaitRetryInterval(double waitRetryInterval) {
        this.waitRetryInterval = waitRetryInterval;
    }

    public boolean isReported() {
        return this.reported;
    }

    public void setReported(boolean reported) {
        this.reported = reported;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    @Override
    public BrowserUtils getUtils() {
        return this.utils;
    }

    public BrowserElementLoader getElementLoader() {
        return this.elementLoader;
    }

    public JavascriptLibrary getJavascriptLibrary() {
        return this.javascriptLibrary;
    }

    public ElementLocator createElementLocator(SearchContext searchContext, Field field) {
        return new DefaultElementLocator(searchContext, field);
    }

    public ElementLocator createElementLocator(SearchContext searchContext, By by) {
        return this.createElementLocator(searchContext, by, false);
    }

    public ElementLocator createElementLocator(SearchContext searchContext, final By by, final boolean lookupCached) {
        return new DefaultElementLocator(searchContext, new AbstractAnnotations(){

            public boolean isLookupCached() {
                return lookupCached;
            }

            public By buildBy() {
                return by;
            }
        });
    }

    public void quit() {
        this.triggerEvent(this.constructEvent(BeforeBrowserQuitEvent.class));
        this.driver.quit();
        this.triggerEvent(this.constructEvent(AfterBrowserQuitEvent.class));
    }

    public void useEnclosingMethodLabel() {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        String s = e.getClassName();
        this.setLabel(s.substring(s.lastIndexOf(46) + 1, s.length()), e.getMethodName());
    }

    public void report(BrowserContext context, String label) {
        this.triggerEvent(this.constructEvent(OnReportEvent.class, context).with(label));
    }

    public synchronized <T extends BrowserEvent> T constructEvent(Class<T> eventCls, BrowserContext context) {
        try {
            return (T)((BrowserEvent)eventCls.getConstructor(new Class[0]).newInstance(new Object[0])).with(context, LocalDateTime.now());
        }
        catch (Exception e) {
            throw new EventConstructException("Unable to construct event " + eventCls.getName(), e);
        }
    }

    @Override
    public BrowserContext getContext() {
        return this;
    }

    @Override
    public Browser getBrowser() {
        return this;
    }

    @Override
    public BrowserConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T> T getConfiguration(Class<T> configuration) {
        return (T)this.configuration;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public <T> T getDriver(Class<T> driver) {
        return (T)this.driver;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public <T> T getPage(Class<T> page) {
        return (T)this.page;
    }

    @Override
    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public boolean isAt(Class<?> page) {
        return this.page != null && page.isAssignableFrom(this.page.getClass());
    }

    @Override
    public void assertAt(Class<?> page) {
        if (!this.isAt(page)) {
            throw new AssertionError((Object)("Page " + page + " is not assignable to actual page " + (this.page == null ? null : this.page.getClass())));
        }
    }

    @Override
    public <T extends Page> T goToSafely(Class<T> page) {
        try {
            return (T)this.goTo((T)((Object)page));
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @Override
    public <T extends Page> T goToSafely(T page) {
        try {
            return this.goTo(page);
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @Override
    public <T extends Page> T initPageSafely(Class<T> page) {
        try {
            return (T)this.initPage((T)((Object)page));
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @Override
    public <T extends Page> T initPageSafely(T page) {
        try {
            return this.initPage(page);
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @Override
    public Page initOnePageSafely(Object ... pages) {
        try {
            return this.initOnePage(pages);
        }
        catch (WebDriverException e) {
            return null;
        }
    }

    @Override
    public <T extends Page> T goTo(Class<T> page) {
        return (T)((Page)this.constructPage(page)).goTo();
    }

    @Override
    public <T extends Page> T goTo(T page) {
        return (T)page.goTo();
    }

    @Override
    public <T extends Page> T initPage(Class<T> page) {
        return (T)((Page)this.constructPage(page)).init();
    }

    @Override
    public <T extends Page> T initPage(T page) {
        return (T)page.init();
    }

    @Override
    public Page initOnePage(Object ... pages) {
        Object verifiedPage = null;
        for (Object page : pages) {
            verifiedPage = page instanceof Page ? this.initPageSafely((Page)page) : this.initPageSafely((Page)((Object)((Class)page)));
            if (verifiedPage == null) continue;
            return verifiedPage;
        }
        throw new VerificationException("Unable to init any of given pages " + String.join((CharSequence)", ", Arrays.asList(pages).stream().map(p -> p instanceof Page ? ((Page)p).getClass().getName() : ((Class)p).getName()).collect(Collectors.toList())));
    }

    @Override
    public <T extends Page> T constructPage(Class<T> page) {
        try {
            Constructor<T> ctor = page.getConstructor(new Class[0]);
            return (T)((Page)ctor.newInstance(new Object[0])).with(this);
        }
        catch (Exception e) {
            throw new PageConstructException("Unable to construct page " + page.getName(), e);
        }
    }

    @Override
    public <T extends BrowserElement> T initBrowserElement(T element) {
        return (T)element.init();
    }

    public <T extends BrowserElement> T initBrowserElement(Class<T> element, BrowserContext context, WebElement webElement, boolean optional) {
        return (T)((BrowserElement)this.constructBrowserElement(element, context, webElement, optional)).init();
    }

    public <T extends BrowserElement> T constructBrowserElement(Class<T> element, BrowserContext context, WebElement webElement, boolean optional) {
        try {
            Constructor<T> ctor = element.getConstructor(new Class[0]);
            return (T)((BrowserElement)ctor.newInstance(new Object[0])).with(context, webElement, optional);
        }
        catch (Exception e) {
            throw new BrowserElementConstructException("Unable to construct module " + element.getName(), e);
        }
    }

    @Override
    public <T extends Logic> T initLogic(T logic) {
        return (T)logic.init();
    }

    public <T extends Logic> T initLogic(Class<T> logic, BrowserContext context) {
        return (T)((Logic)this.constructLogic(logic, context)).init();
    }

    public <T extends Logic> T constructLogic(Class<T> logic, BrowserContext context) {
        try {
            Constructor<T> ctor = logic.getConstructor(new Class[0]);
            return (T)((Logic)ctor.newInstance(new Object[0])).with(context);
        }
        catch (Exception e) {
            throw new LogicConstructException("Unable to construct logic " + logic.getName(), e);
        }
    }

    public void initElements(BrowserContext context) {
        PageFactory.initElements((FieldDecorator)new BrowserFieldDecorator(context), (Object)context);
    }

    @Override
    public void checkIfPresent(WebElement element) throws NoSuchElementException {
        if (element == null) {
            throw new NoSuchElementException("Element is null");
        }
        element.isDisplayed();
    }

    @Override
    public boolean isPresent(WebElement element) {
        try {
            this.checkIfPresent(element);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public boolean isNotPresent(WebElement element) {
        return !this.isPresent(element);
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    @Override
    public <T extends BrowserElement> List<T> find(BrowserContext context, By by, Class<T> elementCls) {
        return this.elementLoader.find(context, by, elementCls);
    }

    @Override
    public <T extends BrowserElement> T findOne(BrowserContext context, By by, Class<T> elementCls, boolean optional) {
        return this.elementLoader.findOne(context, by, elementCls, optional);
    }

    @Override
    public void goToUrl(String url) {
        this.driver.get(url);
    }

    @Override
    public void triggerEvent(BrowserEvent event) {
        event.init();
        this.listeners.forEach(l -> event.notifyEnabled((BrowserListener)l));
    }

    @Override
    public Map<String, Object> getDataHolder() {
        return this.dataHolder;
    }

    @Override
    public String getProperty(String key) {
        return this.configuration instanceof PropertySource ? ((PropertySource)((Object)this.configuration)).getProperty(key) : null;
    }

    @Override
    public void saveFile(String content, String name, String extension) {
        this.saveFile(content.getBytes(), name, extension);
    }

    @Override
    public void saveFile(byte[] bytes, String name, String extension) {
        if (!this.reported) {
            return;
        }
        try {
            Path path = Files.write(this.getUniqueFilePath(name, extension), bytes, new OpenOption[0]);
            this.triggerEvent(this.constructEvent(OnFileSaveEvent.class, this).with(path.toFile()));
        }
        catch (IOException e) {
            throw new BrowserException("Unable to save file " + name, e);
        }
    }

    @Override
    public void saveFile(File file, String name, String extension) {
        if (!this.reported) {
            return;
        }
        try {
            Path path = Files.copy(file.toPath(), this.getUniqueFilePath(name, extension), new CopyOption[0]);
            this.triggerEvent(this.constructEvent(OnFileSaveEvent.class, this).with(path.toFile()));
        }
        catch (IOException e) {
            throw new BrowserException("Unable to save file " + name, e);
        }
    }

    protected Path getFilePath(String name, String extension) {
        return this.reportDir.toPath().resolve(this.utils.join(".", name, extension));
    }

    protected Path getUniqueFilePath(String name, String extension) {
        name = this.escapeFileName(name);
        Path path = this.getFilePath(name, extension);
        int suffix = 0;
        while (path.toFile().exists()) {
            path = this.getFilePath(this.utils.join(LABEL_DELIMITER, name, ++suffix), extension);
        }
        return path;
    }

    protected String escapeFileName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
    }
}

