/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.listener;

import cz.etnetera.seleniumbrowser.browser.Browser;
import cz.etnetera.seleniumbrowser.event.BrowserEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterBrowserQuitEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterChangeValueOfEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterClickOnEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterFindByEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterModuleInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterNavigateBackEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterNavigateForwardEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterNavigateToEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterPageInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.AfterScriptEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeBrowserQuitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeChangeValueOfEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeClickOnEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeDriverConstructEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeFindByEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeModuleInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeNavigateBackEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeNavigateForwardEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeNavigateToEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforePageInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforeScriptEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnExceptionEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnFileSaveEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnModuleInitExceptionEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnPageInitExceptionEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnReportEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class BrowserListener {
    protected Browser browser;
    protected String label;
    protected Set<Class<? extends BrowserEvent>> enabledEvents;
    protected Set<Class<? extends BrowserEvent>> disabledEvents;

    public void init(Browser browser) {
        this.browser = browser;
        this.label = this.generateLabel();
    }

    public boolean isEnabled(BrowserEvent event) {
        return this.isEnabled(event.getClass());
    }

    public boolean isEnabled(Class<? extends BrowserEvent> event) {
        if (this.enabledEvents != null) {
            return this.enabledEvents.contains(event);
        }
        if (this.disabledEvents != null) {
            return !this.disabledEvents.contains(event);
        }
        return true;
    }

    public BrowserListener enable(Class<? extends BrowserEvent> ... events) {
        if (events != null) {
            this.disabledEvents = null;
            if (this.enabledEvents == null) {
                this.enabledEvents = new HashSet<Class<? extends BrowserEvent>>();
            }
            for (Class<? extends BrowserEvent> event : events) {
                this.enabledEvents.add(event);
            }
        }
        return this;
    }

    public BrowserListener disable(Class<? extends BrowserEvent> ... events) {
        if (events != null) {
            this.enabledEvents = null;
            if (this.disabledEvents == null) {
                this.disabledEvents = new HashSet<Class<? extends BrowserEvent>>();
            }
            for (Class<? extends BrowserEvent> event : events) {
                this.disabledEvents.add(event);
            }
        }
        return this;
    }

    public void onReport(OnReportEvent event) {
    }

    public void onFileSave(OnFileSaveEvent event) {
    }

    public void beforeDriverConstruct(BeforeDriverConstructEvent event) {
    }

    public void beforePageInit(BeforePageInitEvent event) {
    }

    public void onPageInitException(OnPageInitExceptionEvent event) {
    }

    public void afterPageInit(AfterPageInitEvent event) {
    }

    public void beforeModuleInit(BeforeModuleInitEvent event) {
    }

    public void onModuleInitException(OnModuleInitExceptionEvent event) {
    }

    public void afterModuleInit(AfterModuleInitEvent event) {
    }

    public void beforeBrowserQuit(BeforeBrowserQuitEvent event) {
    }

    public void afterBrowserQuit(AfterBrowserQuitEvent event) {
    }

    public void beforeNavigateTo(BeforeNavigateToEvent event) {
    }

    public void afterNavigateTo(AfterNavigateToEvent event) {
    }

    public void beforeNavigateBack(BeforeNavigateBackEvent event) {
    }

    public void afterNavigateBack(AfterNavigateBackEvent event) {
    }

    public void beforeNavigateForward(BeforeNavigateForwardEvent event) {
    }

    public void afterNavigateForward(AfterNavigateForwardEvent event) {
    }

    public void beforeFindBy(BeforeFindByEvent event) {
    }

    public void afterFindBy(AfterFindByEvent event) {
    }

    public void beforeClickOn(BeforeClickOnEvent event) {
    }

    public void afterClickOn(AfterClickOnEvent event) {
    }

    public void beforeChangeValueOf(BeforeChangeValueOfEvent event) {
    }

    public void afterChangeValueOf(AfterChangeValueOfEvent event) {
    }

    public void beforeScript(BeforeScriptEvent event) {
    }

    public void afterScript(AfterScriptEvent event) {
    }

    public void onException(OnExceptionEvent event) {
    }

    protected void saveFile(BrowserEvent event, String content, String name, String extension) {
        event.saveFile(content, this.getListenerFileName(name), extension);
    }

    protected void saveFile(BrowserEvent event, byte[] bytes, String name, String extension) {
        event.saveFile(bytes, this.getListenerFileName(name), extension);
    }

    protected void saveFile(BrowserEvent event, File file, String name, String extension) {
        event.saveFile(file, this.getListenerFileName(name), extension);
    }

    protected String getListenerFileName(String name) {
        return this.browser.getUtils().join("-", this.label, name);
    }

    protected String generateLabel() {
        String endTrim;
        String name = this.getClass().getSimpleName();
        return name.endsWith(endTrim = "Listener") ? name.substring(0, name.length() - endTrim.length()) : name;
    }
}

