/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.page;

import cz.etnetera.seleniumbrowser.browser.Browser;
import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.context.VerificationException;
import cz.etnetera.seleniumbrowser.event.impl.AfterPageInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.BeforePageInitEvent;
import cz.etnetera.seleniumbrowser.event.impl.OnPageInitExceptionEvent;
import cz.etnetera.seleniumbrowser.page.PageConfig;
import cz.etnetera.seleniumbrowser.page.PageException;
import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class Page
implements BrowserContext {
    protected String uri;
    protected String uriRegex;
    protected String baseUrl;
    protected String baseUrlRegex;
    protected String url;
    protected String urlRegex;
    protected Boolean urlVerification;
    protected Double waitTimeout;
    protected Double waitRetryInterval;
    protected Double waitPageBeforeInitTimeout;
    protected Browser browser;

    public Page with(Browser browser) {
        this.browser = browser;
        this.configureFromAnnotation();
        this.configureFromBrowser();
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUriRegex() {
        return this.uriRegex;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseUrlRegex() {
        return this.baseUrlRegex;
    }

    public boolean isUrlVerification() {
        return this.urlVerification == null ? false : this.urlVerification;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        String uri = this.getUri();
        return uri == null ? null : this.getBaseUrl() + uri;
    }

    public String getUrlRegex() {
        if (this.urlRegex != null) {
            return this.urlRegex;
        }
        String baseUrlRegex = this.getBaseUrlRegex();
        if (baseUrlRegex == null) {
            return null;
        }
        String uriRegex = this.getUriRegex();
        if (uriRegex == null) {
            String uri = this.getUri();
            if (uri == null) {
                return null;
            }
            uriRegex = Pattern.quote(uri) + ".*";
        }
        return baseUrlRegex + uriRegex;
    }

    public Page goTo() {
        String url = this.getUrl();
        if (url == null) {
            throw new PageException("It is not possible to go to page without url " + this.getClass().getName());
        }
        this.goToUrl(url);
        return this.init();
    }

    public final Page init() {
        if (this.waitPageBeforeInitTimeout != null) {
            this.waiting(this.waitPageBeforeInitTimeout).sleep();
        }
        try {
            this.triggerEvent(this.constructEvent(BeforePageInitEvent.class).with(this));
            this.beforeInit();
            this.beforeInitElements();
            this.initElements();
            this.afterInitElements();
            this.beforeSetup();
            this.setup();
            this.afterSetup();
            this.beforeVerify();
            this.verify();
            this.afterVerify();
            this.setPage(this);
            this.afterInit();
        }
        catch (Exception e) {
            this.triggerEvent(this.constructEvent(OnPageInitExceptionEvent.class).with(this, e));
            throw e;
        }
        this.triggerEvent(this.constructEvent(AfterPageInitEvent.class).with(this));
        return this;
    }

    @Override
    public BrowserContext getContext() {
        return this.browser;
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public double getWaitTimeout() {
        return this.waitTimeout == null ? 0.0 : this.waitTimeout;
    }

    public void setWaitTimeout(double waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    @Override
    public double getWaitRetryInterval() {
        return this.waitRetryInterval == null ? 0.0 : this.waitRetryInterval;
    }

    public void setWaitRetryInterval(double waitRetryInterval) {
        this.waitRetryInterval = waitRetryInterval;
    }

    public List<WebElement> findElements(By by) {
        return this.browser.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.browser.findElement(by);
    }

    public void verify() throws VerificationException {
        try {
            this.verifyUrl();
            this.verifyThis();
        }
        catch (Exception e) {
            throw new VerificationException("Page is wrong " + this.getClass().getName(), e);
        }
    }

    protected void verifyUrl() {
        if (!this.isUrlVerification()) {
            return;
        }
        String urlRegex = this.getUrlRegex();
        if (urlRegex == null) {
            return;
        }
        String currentUrl = this.getDriver().getCurrentUrl();
        if (currentUrl != null && !currentUrl.matches(urlRegex)) {
            throw new VerificationException("Unable to verify page url for " + this.getClass().getName() + " using url regex " + urlRegex + " against current url " + currentUrl);
        }
    }

    protected void configureFromAnnotation() {
        PageConfig config = this.getClass().getDeclaredAnnotation(PageConfig.class);
        if (config != null) {
            this.applyAnnotationConfiguration(config);
        }
    }

    protected void applyAnnotationConfiguration(PageConfig config) {
        if (config.uri().length > 0) {
            this.uri = config.uri()[0];
        }
        if (config.uriRegex().length > 0) {
            this.uriRegex = config.uriRegex()[0];
        }
        if (config.baseUrl().length > 0) {
            this.baseUrl = config.baseUrl()[0];
        }
        if (config.baseUrlRegex().length > 0) {
            this.baseUrlRegex = config.baseUrlRegex()[0];
        }
        if (config.urlVerification().length > 0) {
            this.urlVerification = config.urlVerification()[0];
        }
        if (config.url().length > 0) {
            this.url = config.url()[0];
        }
        if (config.urlRegex().length > 0) {
            this.urlRegex = config.urlRegex()[0];
        }
        if (config.waitTimeout().length > 0) {
            this.waitTimeout = config.waitTimeout()[0];
        }
        if (config.waitRetryInterval().length > 0) {
            this.waitRetryInterval = config.waitRetryInterval()[0];
        }
        if (config.waitBeforePageInitTimeout().length > 0) {
            this.waitPageBeforeInitTimeout = config.waitBeforePageInitTimeout()[0];
        }
    }

    protected void configureFromBrowser() {
        if (this.browser != null) {
            this.applyBrowserConfiguration(this.browser);
        }
    }

    protected void applyBrowserConfiguration(Browser browser) {
        if (this.baseUrl == null) {
            this.baseUrl = browser.getBaseUrl();
        }
        if (this.baseUrlRegex == null) {
            this.baseUrlRegex = browser.getBaseUrlRegex();
        }
        if (this.urlVerification == null) {
            this.urlVerification = browser.isUrlVerification();
        }
        if (this.waitTimeout == null) {
            this.waitTimeout = browser.getWaitTimeout();
        }
        if (this.waitRetryInterval == null) {
            this.waitRetryInterval = browser.getWaitRetryInterval();
        }
    }

    protected void setup() {
    }

    protected void verifyThis() {
    }

    protected void beforeInit() {
    }

    protected void beforeInitElements() {
    }

    protected void afterInitElements() {
    }

    protected void beforeSetup() {
    }

    protected void afterSetup() {
    }

    protected void beforeVerify() {
    }

    protected void afterVerify() {
    }

    protected void afterInit() {
    }
}

