/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.testrail.adapter.junit;

import com.codepine.api.testrail.TestRail;
import com.codepine.api.testrail.TestRailException;
import com.codepine.api.testrail.model.Result;
import cz.etnetera.testrail.adapter.junit.TRService;
import cz.etnetera.testrail.adapter.junit.TRTest;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TRJunitWatcher
extends TestWatcher {
    private TRService trService = TRService.getInstance();
    private TestRail testRail = this.trService.getTestRail();
    private Result result;
    private LocalDateTime started;

    protected void starting(Description description) {
        this.started = LocalDateTime.now();
    }

    protected void succeeded(Description description) {
        this.result = new Result().setStatusId(Integer.valueOf(1));
    }

    protected void failed(Throwable e, Description description) {
        this.result = new Result().setStatusId(Integer.valueOf(5)).setComment(e.toString());
    }

    protected void finished(Description description) {
        TRTest testConfig = this.getInfo(description);
        if (this.trService.isRunCreated() && this.testAllowsWritting(testConfig)) {
            try {
                this.result.setCreatedOn(new Date()).setElapsed(Duration.between(this.started, LocalDateTime.now()).getSeconds() + "s");
                List customResultFields = (List)this.testRail.resultFields().list().execute();
                this.testRail.results().addForCase(this.trService.getRun().getId(), testConfig.testCaseId(), this.result, customResultFields).execute();
            }
            catch (TestRailException e) {
                System.err.println("Error while writting test result to Testrail: " + (Object)((Object)e));
            }
        } else {
            System.err.println("Result was not written to Testrail. Possible reasons: \n1) TRService#createRunForSuite was not called in @BeforeClass method of Junit Suite \n2) TRTest annotation was not provided to the test \n3) Writing disabled in annotation");
        }
    }

    private boolean testAllowsWritting(TRTest testConfig) {
        return testConfig != null && testConfig.enabled();
    }

    private TRTest getInfo(Description description) {
        return (TRTest)description.getAnnotation(TRTest.class);
    }
}

