/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.testrail.adapter.junit;

import java.io.IOException;
import java.util.Properties;

public class TRPropertyLoader {
    private static TRPropertyLoader loader;
    private Properties systemProperties = System.getProperties();
    private Properties fileProperties = new Properties();

    public static TRPropertyLoader getInstance() {
        if (loader == null) {
            loader = new TRPropertyLoader();
        }
        return loader;
    }

    private TRPropertyLoader() {
    }

    public String getProperty(String key) {
        String value;
        if (this.fileProperties.isEmpty()) {
            try {
                this.fileProperties.load(TRPropertyLoader.class.getClassLoader().getResourceAsStream("testrail.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while loading file resources/testrail.properties");
            }
        }
        String string = value = this.systemProperties.getProperty(key) != null ? System.getProperty(key) : this.fileProperties.getProperty(key);
        if (value == null) {
            throw new NullPointerException(key + " was not specified neither in resources/testrail.properties nor as system property");
        }
        return value;
    }

    public String getUrl() {
        return this.getProperty("testrail.url");
    }

    public String getUsername() {
        return this.getProperty("testrail.username");
    }

    public String getPassword() {
        return this.getProperty("testrail.password");
    }

    public int getProjectid() {
        return Integer.valueOf(this.getProperty("testrail.projectid"));
    }
}

