/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.cxf;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import cz.gopay.api.v3.AbstractGPConnector;
import cz.gopay.api.v3.model.access.AccessToken;
import cz.gopay.api.v3.model.access.OAuth;
import java.util.ArrayList;
import java.util.Date;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;

public class CXFGPConnector
extends AbstractGPConnector {
    private CXFGPConnector(String api) {
        super(api);
    }

    private CXFGPConnector(String api, AccessToken token) {
        super(api, token);
    }

    public static CXFGPConnector build(String api) {
        return new CXFGPConnector(api);
    }

    public static CXFGPConnector build(String api, String accessToken, String refreshToken, Date expiresIn) {
        return new CXFGPConnector(api, new AccessToken(OAuth.TOKEN_TYPE_BEARER, accessToken, refreshToken, expiresIn.getTime()));
    }

    protected <T> T createRESTClientProxy(String apiUrl, Class<T> proxy) {
        ArrayList<JacksonJaxbJsonProvider> providers = new ArrayList<JacksonJaxbJsonProvider>();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        providers.add(jsonProvider);
        Object t = JAXRSClientFactory.create((String)apiUrl, proxy, providers, (boolean)true);
        Client client = (Client)t;
        client.header("User-Agent", new Object[]{this.getImplementationName() + "=" + this.getVersion()});
        return (T)t;
    }

    protected String getImplementationName() {
        return "gp-java-api-v3-apache-cxf";
    }
}

