/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.apacheclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import cz.gopay.api.v3.impl.apacheclient.APIResponse;
import cz.gopay.api.v3.model.APIError;
import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Response;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class AbstractImpl {
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String SCOPE = "scope";
    protected static final String GRANT_TYPE = "grant_type";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT = "Accept";
    protected String apiUrl;
    private final ObjectMapper mapper;
    protected Logger logger;

    public AbstractImpl(String apiUrl) {
        this.apiUrl = apiUrl;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
    }

    protected <T> T unMarshall(Response response, Class<T> entity) {
        try {
            HttpResponse httpresponse = response.returnResponse();
            int code = httpresponse.getStatusLine().getStatusCode();
            byte[] body = EntityUtils.toByteArray((HttpEntity)httpresponse.getEntity());
            String json = new String(body);
            JsonNode tree = this.mapper.readTree(json);
            APIError error = (APIError)this.mapper.treeToValue((TreeNode)tree, APIError.class);
            if (error.getDateIssued() != null) {
                throw new WebApplicationException((javax.ws.rs.core.Response)new APIResponse(error, code));
            }
            return (T)this.mapper.treeToValue((TreeNode)tree, entity);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String marshall(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

