/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.apacheclient;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import cz.gopay.api.v3.impl.apacheclient.APIResponse;
import cz.gopay.api.v3.model.APIError;
import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class AbstractImpl {
    protected static final String IMPLEMENTATION_NAME = "${project.artifactId}";
    protected static final String VERSION = "${project.artifactId}";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String SCOPE = "scope";
    protected static final String GRANT_TYPE = "grant_type";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT = "Accept";
    protected static final String USER_AGENT = "User-Agent";
    protected String apiUrl;
    private final ObjectMapper mapper;
    protected Logger logger;

    public AbstractImpl(String apiUrl) {
        this.apiUrl = apiUrl;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
    }

    protected <T> T unMarshall(org.apache.http.client.fluent.Response response, Class<T> entity) {
        String json = null;
        try {
            HttpResponse httpresponse = response.returnResponse();
            json = this.entityToString(httpresponse);
            JsonNode tree = this.mapper.readTree(json);
            APIError error = (APIError)this.mapper.treeToValue((TreeNode)tree, APIError.class);
            if (error.getDateIssued() != null) {
                int code = httpresponse.getStatusLine().getStatusCode();
                throw new WebApplicationException((Response)new APIResponse(error, code));
            }
            return (T)this.mapper.treeToValue((TreeNode)tree, entity);
        }
        catch (JsonParseException e) {
            throw new WebApplicationException("Could not parse json " + json);
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected <T> T unMarshallComplexResponse(org.apache.http.client.fluent.Response response, TypeReference<T> typeReference) {
        try {
            HttpResponse httpresponse = response.returnResponse();
            String json = this.entityToString(httpresponse);
            JsonNode tree = this.mapper.readTree(json);
            if (tree.findValue("errors") != null) {
                APIError error = (APIError)this.mapper.treeToValue((TreeNode)tree, APIError.class);
                int code = httpresponse.getStatusLine().getStatusCode();
                throw new WebApplicationException((Response)new APIResponse(error, code));
            }
            return (T)this.mapper.readValue(json.getBytes(), typeReference);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String entityToString(HttpResponse response) throws IOException {
        byte[] body = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        return new String(body);
    }

    protected String marshall(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

