/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.apacheclient;

import com.fasterxml.jackson.core.type.TypeReference;
import cz.gopay.api.v3.PaymentClient;
import cz.gopay.api.v3.impl.apacheclient.AbstractImpl;
import cz.gopay.api.v3.impl.apacheclient.HttpClientAuthClientImpl;
import cz.gopay.api.v3.model.access.AuthHeader;
import cz.gopay.api.v3.model.common.Currency;
import cz.gopay.api.v3.model.eet.EETReceipt;
import cz.gopay.api.v3.model.eet.EETReceiptFilter;
import cz.gopay.api.v3.model.payment.BasePayment;
import cz.gopay.api.v3.model.payment.CapturePayment;
import cz.gopay.api.v3.model.payment.NextPayment;
import cz.gopay.api.v3.model.payment.Payment;
import cz.gopay.api.v3.model.payment.PaymentResult;
import cz.gopay.api.v3.model.payment.RefundPayment;
import cz.gopay.api.v3.model.payment.support.AccountStatement;
import cz.gopay.api.v3.model.payment.support.PaymentInstrumentRoot;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.WebApplicationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;

public class HttpClientPaymentClientImpl
extends AbstractImpl
implements PaymentClient {
    protected HttpClientPaymentClientImpl(String apiUrl) {
        super(apiUrl);
        this.logger = LogManager.getLogger(HttpClientAuthClientImpl.class);
    }

    public Payment createPayment(AuthHeader authHeader, BasePayment createPayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(createPayment), ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }

    public PaymentResult refundPayment(AuthHeader authHeader, Long id, Long amount) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/refund")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString("amount=" + amount, ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult refundPayment(@BeanParam AuthHeader authHeader, Long id, RefundPayment refundPayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/refund")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(refundPayment), ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public Payment createRecurrentPayment(AuthHeader authHeader, Long id, NextPayment createPayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/create-recurrence")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(createPayment), ContentType.TEXT_XML).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }

    public PaymentResult voidRecurrence(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/void-recurrence")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult capturePayment(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/capture")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult capturePayment(AuthHeader authHeader, Long id, CapturePayment capturePayment) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/capture")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(capturePayment), ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public PaymentResult voidAuthorization(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/payments/payment/" + id + "/void-authorization")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentResult.class);
    }

    public Payment getPayment(AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Get((String)(this.apiUrl + "/payments/payment/" + id)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, Payment.class);
    }

    public PaymentInstrumentRoot getPaymentInstruments(AuthHeader authHeader, Long goId, Currency currency) {
        Response response = null;
        try {
            response = Request.Get((String)(this.apiUrl + "/eshops/eshop/" + goId + "/payment-instruments/" + currency)).addHeader("Accept", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshall(response, PaymentInstrumentRoot.class);
    }

    public List<EETReceipt> findEETReceiptsByFilter(@BeanParam AuthHeader authHeader, EETReceiptFilter filter) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/eet-receipts")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(filter), ContentType.APPLICATION_JSON).execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshallComplexResponse(response, new TypeReference<List<EETReceipt>>(){});
    }

    public List<EETReceipt> getEETReceiptByPaymentId(@BeanParam AuthHeader authHeader, Long id) {
        Response response = null;
        try {
            response = Request.Get((String)(this.apiUrl + "/payments/payment/" + id + "/eet-receipts")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").execute();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return this.unMarshallComplexResponse(response, new TypeReference<List<EETReceipt>>(){});
    }

    public byte[] getStatement(AuthHeader authHeader, AccountStatement accountStatement) {
        Response response = null;
        try {
            response = Request.Post((String)(this.apiUrl + "/accounts/account-statement")).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("Authorization", authHeader.getAuhorization()).addHeader("User-Agent", "${project.artifactId}=${project.artifactId}").bodyString(this.marshall(accountStatement), ContentType.APPLICATION_JSON).execute();
            HttpResponse httpresponse = response.returnResponse();
            return EntityUtils.toByteArray((HttpEntity)httpresponse.getEntity());
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }
}

