/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3;

import cz.gopay.api.v3.model.APIError;
import cz.gopay.api.v3.model.ErrorElement;
import java.util.Date;
import java.util.List;

public class GPClientException
extends Exception {
    private final int httpResultCode;
    private final APIError error;

    public GPClientException(int httpResultCode, APIError error) {
        this.error = error;
        this.httpResultCode = httpResultCode;
    }

    public APIError getError() {
        return this.error;
    }

    public Date getDateIssued() {
        return this.error.getDateIssued();
    }

    public List<ErrorElement> getErrorMessages() {
        return this.error.getErrorMessages();
    }

    public String extractMessage() {
        StringBuilder sb = new StringBuilder();
        for (ErrorElement msg : this.getErrorMessages()) {
            sb.append("RC[").append(this.httpResultCode).append("]");
            if (msg.getField() != null) {
                sb.append("Field: ").append(msg.getField());
            }
            if (msg.getErrorName() != null) {
                sb.append(" Name: ").append(msg.getErrorName()).append("[").append(msg.getErrorCode()).append("]");
            }
            if (msg.getMessage() != null) {
                sb.append(" Msg: ").append(msg.getMessage());
            }
            if (msg.getDescription() == null) continue;
            sb.append(" Desc: ").append(msg.getDescription());
        }
        return sb.toString();
    }
}

