/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.payment;

import cz.gopay.api.v3.model.payment.AbstractPaymentBuilder;
import cz.gopay.api.v3.model.payment.BasePayment;
import cz.gopay.api.v3.model.payment.support.Callback;
import cz.gopay.api.v3.model.payment.support.Payer;
import cz.gopay.api.v3.model.payment.support.PayerContact;
import cz.gopay.api.v3.model.payment.support.PaymentInstrument;
import cz.gopay.api.v3.model.payment.support.Recurrence;
import cz.gopay.api.v3.model.payment.support.RecurrenceCycle;
import cz.gopay.api.v3.model.payment.support.Target;
import java.util.Date;

public class BasePaymentBuilder
extends AbstractPaymentBuilder<BasePayment, BasePaymentBuilder> {
    private String lang;
    private Callback callback;
    private Boolean preauth;
    private Recurrence recurrence;
    private Payer payer;
    private Target target;

    @Override
    public BasePayment build() {
        BasePayment payment = new BasePayment();
        if (!this.items.isEmpty()) {
            payment.setItems(this.items);
        }
        payment.setLang(this.lang);
        if (!this.additionalParams.isEmpty()) {
            payment.setAdditionalParams(this.additionalParams);
        }
        payment.setOrderDescription(this.orderDescription);
        payment.setAmount(this.amount);
        payment.setCurrency(this.currency);
        payment.setOrderNumber(this.orderNumber);
        payment.setCallback(this.callback);
        if (this.preauth != null) {
            payment.setPreAuthorization(this.preauth);
        }
        payment.setTarget(this.target);
        payment.setPayer(this.payer);
        return payment;
    }

    public BasePaymentBuilder preauthorize() {
        this.preauth = true;
        return this;
    }

    public BasePaymentBuilder withCallback(String returnUrl, String notificationUrl) {
        return this.withCallback(Callback.of(notificationUrl, returnUrl));
    }

    public BasePaymentBuilder withCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public BasePaymentBuilder inLang(String lang) {
        this.lang = lang;
        return this;
    }

    public BasePaymentBuilder onDemandRecurrence(Date recurrenceDateTo) {
        this.recurrence = Recurrence.build(recurrenceDateTo).onDemand();
        return this;
    }

    public BasePaymentBuilder setRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public BasePaymentBuilder timeIntervalRecurrence(RecurrenceCycle recurrenceCycle, Integer recurrencePeriod, Date recurrenceDateTo) {
        this.recurrence = Recurrence.build(recurrenceDateTo).withTimeInterval(recurrenceCycle, recurrencePeriod);
        return this;
    }

    public BasePaymentBuilder payer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public BasePaymentBuilder withPayerContact(PayerContact contact) {
        if (this.payer == null) {
            this.payer = Payer.build();
        }
        this.payer.setContact(contact);
        return this;
    }

    public BasePaymentBuilder withPaymentInstrument(PaymentInstrument paymentInstrument) {
        if (this.payer == null) {
            this.payer = Payer.build();
        }
        this.payer.setPaymentInstrument(paymentInstrument);
        return this;
    }

    public BasePaymentBuilder withDefaultPaymentInstrument(PaymentInstrument paymentInstrument) {
        if (this.payer == null) {
            this.payer = Payer.build();
        }
        this.payer.setDefaultPaymentInstrument(paymentInstrument);
        return this;
    }

    public BasePaymentBuilder toEshop(Long goId) {
        this.target = Target.createEShop(goId);
        return this;
    }

    public BasePaymentBuilder toEWallet(String email) {
        this.target = Target.createEWallet(email);
        return this;
    }

    @Override
    protected BasePaymentBuilder getInstance() {
        return this;
    }
}

