/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.payment.support;

import cz.gopay.api.v3.Builder;
import cz.gopay.api.v3.model.payment.support.Payer;
import cz.gopay.api.v3.model.payment.support.PayerContact;
import cz.gopay.api.v3.model.payment.support.PaymentInstrument;
import java.util.ArrayList;
import java.util.List;

public class PayerBuilder
implements Builder<Payer> {
    private PaymentInstrument paymentInstrument;
    private PaymentInstrument defaultPaymentInstrument;
    private List<PaymentInstrument> allowedPaymentInstruments = new ArrayList<PaymentInstrument>();
    private List<String> allowedSwifts = new ArrayList<String>();
    private PayerContact contact;

    @Override
    public Payer build() {
        Payer payer = new Payer();
        payer.setAllowedPaymentInstruments(this.allowedPaymentInstruments);
        payer.setDefaultPaymentInstrument(this.defaultPaymentInstrument);
        payer.setContact(this.contact);
        payer.setAllowedSwifts(this.allowedSwifts);
        payer.setPaymentInstrument(this.paymentInstrument);
        return payer;
    }

    public PayerBuilder withPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    public PayerBuilder withDefaultPaymentInstrument(PaymentInstrument defaultPaymentInstrument) {
        this.defaultPaymentInstrument = defaultPaymentInstrument;
        return this;
    }

    public PayerBuilder withAllowedPaymentInstruments(List<PaymentInstrument> allowedInstruments) {
        this.allowedPaymentInstruments = allowedInstruments;
        return this;
    }

    public PayerBuilder addAllowedPaymentMethod(PaymentInstrument allowedInstrument) {
        if (this.allowedPaymentInstruments == null) {
            this.allowedPaymentInstruments = new ArrayList<PaymentInstrument>();
        }
        this.allowedPaymentInstruments.add(allowedInstrument);
        return this;
    }

    public PayerBuilder withAllowedSwifts(List<String> allowedSwifts) {
        this.allowedSwifts = allowedSwifts;
        return this;
    }

    public PayerBuilder addAllowedSwift(String allowedSwift) {
        if (this.allowedSwifts == null) {
            this.allowedSwifts = new ArrayList<String>();
        }
        this.allowedSwifts.add(allowedSwift);
        return this;
    }

    public PayerBuilder withContactData(PayerContact contact) {
        this.contact = contact;
        return this;
    }
}

