/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3;

import cz.gopay.api.v3.AuthClient;
import cz.gopay.api.v3.GPClientException;
import cz.gopay.api.v3.GPExceptionHandler;
import cz.gopay.api.v3.IGPConnector;
import cz.gopay.api.v3.PaymentClient;
import cz.gopay.api.v3.model.access.AccessToken;
import cz.gopay.api.v3.model.access.AuthHeader;
import cz.gopay.api.v3.model.access.OAuth;
import cz.gopay.api.v3.model.common.Currency;
import cz.gopay.api.v3.model.eet.EETReceipt;
import cz.gopay.api.v3.model.eet.EETReceiptFilter;
import cz.gopay.api.v3.model.payment.BasePayment;
import cz.gopay.api.v3.model.payment.CapturePayment;
import cz.gopay.api.v3.model.payment.NextPayment;
import cz.gopay.api.v3.model.payment.Payment;
import cz.gopay.api.v3.model.payment.PaymentResult;
import cz.gopay.api.v3.model.payment.RefundPayment;
import cz.gopay.api.v3.model.payment.support.AccountStatement;
import cz.gopay.api.v3.model.payment.support.PaymentInstrumentRoot;
import cz.gopay.api.v3.model.supercash.SupercashBatch;
import cz.gopay.api.v3.model.supercash.SupercashBatchRequest;
import cz.gopay.api.v3.model.supercash.SupercashBatchResult;
import cz.gopay.api.v3.model.supercash.SupercashBatchState;
import cz.gopay.api.v3.model.supercash.SupercashCoupon;
import cz.gopay.api.v3.model.supercash.SupercashCouponRequest;
import cz.gopay.api.v3.model.supercash.SupercashPayment;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.log4j.Logger;

public abstract class AbstractGPConnector
implements IGPConnector {
    public static final String VERSION = "3.4.8";
    protected static final Logger logger = Logger.getLogger(AbstractGPConnector.class);
    public static int CONNECTION_POOL_SIZE = 1;
    public static int CONNECTION_SETUP_TO = 1;
    public static int CONNECTION_SERVICE_TO = 1;
    protected String apiUrl;
    protected AccessToken accessToken;

    public AbstractGPConnector(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public AbstractGPConnector(String apiUrl, AccessToken token) {
        this(apiUrl);
        this.accessToken = token;
    }

    protected abstract <T> T createRESTClientProxy(String var1, Class<T> var2);

    @Override
    public IGPConnector getAppToken(String clientId, String clientCredentials) throws GPClientException {
        return this.getAppToken(clientId, clientCredentials, OAuth.SCOPE_PAYMENT_CREATE);
    }

    @Override
    public IGPConnector getAppToken(String clientId, String clientCredentials, String scope) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": get-token [" + clientId + "]"));
            AuthClient simple = this.createRESTClientProxy(this.apiUrl, AuthClient.class);
            this.accessToken = simple.loginApplication(AuthHeader.build(clientId, clientCredentials), OAuth.GRANT_TYPE_CLIENT_CREDENTIALS, scope != null ? scope : OAuth.SCOPE_PAYMENT_ALL);
            logger.debug((Object)(this.getClass().getSimpleName() + ": get-token [" + clientId + "] -> [" + this.accessToken.getAccessToken() + "]"));
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": get-token Error [" + clientId + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
        }
        return this;
    }

    @Override
    public Payment createPayment(BasePayment payment) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": create-payment payer[" + payment.getPayer() + "] -> [" + payment.getTarget() + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.createPayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), payment);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": create-payment Error [" + payment.getPayer() + "] -> [" + payment.getTarget() + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult refundPayment(Long id, Long amount) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": refund-payment [" + id + "] amnt[" + amount + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            PaymentResult r = paymentClient.refundPayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id, amount);
            return r;
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": refund-payment Error [" + id + "] amnt[" + amount + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult refundPayment(Long id, RefundPayment refundPayment) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": refund-payment [" + id + "] amnt[" + refundPayment + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            PaymentResult r = paymentClient.refundPayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id, refundPayment);
            return r;
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": refund-payment Error [" + id + "] amnt[" + refundPayment + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public Payment createRecurrentPayment(Long id, NextPayment nextPayment) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": create-recurrent - parent id[" + id + "] [" + nextPayment.getOrderNumber() + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.createRecurrentPayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id, nextPayment);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": create-recurrent Error parent id[" + id + "] [" + nextPayment.getOrderNumber() + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult voidRecurrency(Long id) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": void-recurrency parent id [" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.voidRecurrence(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": void recurrency Error parent id[" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult capturePayment(Long id) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": capture payment [" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.capturePayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": capture payment Error [" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult capturePayment(Long id, CapturePayment capturePayment) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": capture payment with amount [" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.capturePayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id, capturePayment);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": capture payment Error [" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentResult voidAuthorization(Long id) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": void auth payment [" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.voidAuthorization(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": void auth payment Error [" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public Payment paymentStatus(Long id) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": payment-status [" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getPayment(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": payment-status Error [" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public PaymentInstrumentRoot generatePaymentInstruments(Long goId, Currency currency) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": payment-instruments [" + goId + "][" + (Object)((Object)currency) + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getPaymentInstruments(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), goId, currency);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": payment-instruments Error [" + goId + "][" + (Object)((Object)currency) + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public byte[] generateStatement(AccountStatement accountStatement) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": generate-statement [" + accountStatement + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getStatement(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), accountStatement);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": generate-statement Error [" + accountStatement + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public List<EETReceipt> findEETREceiptsByFilter(EETReceiptFilter filter) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + "eet-receipt findByFilter " + filter.toString()));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.findEETReceiptsByFilter(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), filter);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": eet-receipt findByFilter " + filter.toString() + " RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public List<EETReceipt> getEETReceiptByPaymentId(Long id) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + "eet-receipt findByPaymentId PaymentId=[" + id + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getEETReceiptByPaymentId(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), id);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": eet-receipt findByPaymentId PaymentId=[" + id + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashCoupon createSupercashCoupon(SupercashCouponRequest couponRequest) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": create supercash coupon [" + couponRequest + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.createSupercashCoupon(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), couponRequest);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": create supercash coupon Error [" + couponRequest + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashBatchResult createSupercashCouponBatch(SupercashBatchRequest batchRequest) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": create supercash coupon batch [" + batchRequest + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.createSupercashCouponBatch(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), batchRequest);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": create supercash coupon batch Error [" + batchRequest + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashBatchState getSupercashCouponBatchStatus(Long batchId) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": get supercash coupon batch status [" + batchId + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getSupercashCouponBatchStatus(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), batchId);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": get supercash coupon batch status Error [" + batchId + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashBatch getSupercashCouponBatch(Long goId, Long batchId) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": get supercash coupon batch [" + goId + "][" + batchId + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getSupercashCouponBatch(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), goId, batchId);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": get supercash coupon batch Error [" + goId + "][" + batchId + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashBatch findSupercashCoupons(Long goId, Long ... paymentSessionIds) throws GPClientException {
        try {
            String convertedOutput = "";
            for (Long paymentId : paymentSessionIds) {
                convertedOutput = convertedOutput + paymentId + ",";
            }
            convertedOutput = convertedOutput.substring(0, convertedOutput.length() - 1);
            logger.debug((Object)(this.getClass().getSimpleName() + ": find supercash coupons [" + goId + "][" + convertedOutput + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.findSupercashCoupons(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), goId, convertedOutput);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": get supercash coupon batch Error [" + goId + "]" + paymentSessionIds.toString() + " RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public SupercashPayment getSupercashCoupon(Long couponId) throws GPClientException {
        try {
            logger.debug((Object)(this.getClass().getSimpleName() + ": get supercash coupon [" + couponId + "]"));
            PaymentClient paymentClient = this.createRESTClientProxy(this.apiUrl, PaymentClient.class);
            return paymentClient.getSupercashCoupon(AuthHeader.build(this.accessToken != null ? this.accessToken.getAccessToken() : null), couponId);
        }
        catch (WebApplicationException e) {
            logger.fatal((Object)(this.getClass().getSimpleName() + ": get supercash coupon Error [" + couponId + "] RC [" + e.getResponse().getStatus() + "] Ex: " + e.getResponse().getStatusInfo()), (Throwable)e);
            GPExceptionHandler.handleException(e);
            return null;
        }
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    protected abstract String getImplementationName();

    public String getVersion() {
        return VERSION;
    }
}

