/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.common;

import cz.gopay.api.v3.model.payment.support.PaymentInstrument;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlEnum(value=String.class)
public enum CheckoutGroup {
    CARD_PAYMENT("card-payment", EnumSet.of(PaymentInstrument.PAYMENT_CARD)),
    BANK_TRANSFER("bank-transfer", EnumSet.of(PaymentInstrument.BANK_ACCOUNT)),
    WALLET("wallet", EnumSet.of(PaymentInstrument.GOPAY, PaymentInstrument.BITCOIN, PaymentInstrument.PAYPAL)),
    OTHERS("others", EnumSet.of(PaymentInstrument.PRSMS, PaymentInstrument.MPAYMENT, PaymentInstrument.PAYSAFECARD, PaymentInstrument.MASTERPASS));

    private final String name;
    private final Set<PaymentInstrument> paymentInstruments;

    private CheckoutGroup(String name, Set<PaymentInstrument> paymentInstruments) {
        this.name = name;
        this.paymentInstruments = paymentInstruments;
    }

    public String getName() {
        return this.name;
    }

    public Set<PaymentInstrument> getPaymentInstruments() {
        return this.paymentInstruments;
    }

    public String toString() {
        return this.name;
    }

    public static CheckoutGroup findByInstrument(PaymentInstrument instrument) {
        for (CheckoutGroup group : CheckoutGroup.values()) {
            if (!group.getPaymentInstruments().contains((Object)instrument)) continue;
            return group;
        }
        return null;
    }

    public static CheckoutGroup getByStringName(String stringName) {
        CheckoutGroup result = null;
        for (CheckoutGroup item : EnumSet.allOf(CheckoutGroup.class)) {
            if (!String.valueOf((Object)item).equals(stringName)) continue;
            result = item;
            break;
        }
        return result;
    }
}

