/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.common;

import java.util.EnumSet;

public enum Currency {
    CZK(203),
    EUR(978),
    PLN(985),
    HUF(348),
    USD(840),
    GBP(826),
    BGN(975),
    RON(946);

    public static final String CODE_CZK;
    public static final String CODE_EUR;
    public static final String CODE_PLN;
    public static final String CODE_HUF;
    public static final String CODE_USD;
    public static final String CODE_GBP;
    public static final String CODE_BGN;
    public static final String CODE_RON;
    private Integer numericalCode;

    private Currency(Integer numericalCode) {
        this.numericalCode = numericalCode;
    }

    public Integer getNumericalCode() {
        return this.numericalCode;
    }

    public String getCode() {
        return String.valueOf((Object)this);
    }

    public void setNumericalCode(int numericalCode) {
        this.numericalCode = numericalCode;
    }

    public static Currency getByCode(String code) {
        Currency result = null;
        for (Currency item : EnumSet.allOf(Currency.class)) {
            if (!String.valueOf((Object)item).equals(code)) continue;
            result = item;
            break;
        }
        return result;
    }

    public static Currency getByNumericalCode(Integer code) {
        Currency result = null;
        for (Currency item : EnumSet.allOf(Currency.class)) {
            if (!item.getNumericalCode().equals(code)) continue;
            result = item;
            break;
        }
        return result;
    }

    static {
        CODE_CZK = String.valueOf((Object)CZK);
        CODE_EUR = String.valueOf((Object)EUR);
        CODE_PLN = String.valueOf((Object)PLN);
        CODE_HUF = String.valueOf((Object)HUF);
        CODE_USD = String.valueOf((Object)USD);
        CODE_GBP = String.valueOf((Object)GBP);
        CODE_BGN = String.valueOf((Object)BGN);
        CODE_RON = String.valueOf((Object)RON);
    }
}

