/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum CountryCode {
    CZE(1),
    SVK(2),
    AFG(100),
    ALA(101),
    ALB(102),
    DZA(103),
    ASM(104),
    VIR(105),
    AND(106),
    AGO(107),
    AIA(108),
    ATA(109),
    ATG(110),
    ARG(111),
    ARM(112),
    ABW(113),
    AUS(114),
    AZE(115),
    BHS(116),
    BHR(117),
    BGD(118),
    BRB(119),
    BEL(120),
    BLZ(121),
    BLR(122),
    BEN(123),
    BMU(124),
    BTN(125),
    BOL(126),
    BES(127),
    BIH(128),
    BWA(129),
    BVT(130),
    BRA(131),
    IOT(132),
    VGB(133),
    BRN(134),
    BGR(135),
    BFA(136),
    BDI(137),
    COK(138),
    CUW(139),
    TCD(140),
    MNE(141),
    CHN(143),
    DNK(144),
    COD(145),
    DMA(146),
    DOM(147),
    DJI(148),
    EGY(149),
    ECU(150),
    ERI(151),
    EST(152),
    ETH(153),
    FRO(154),
    FLK(155),
    FJI(156),
    PHL(157),
    FIN(158),
    FRA(159),
    GUF(160),
    ATF(161),
    PYF(162),
    GAB(163),
    GMB(164),
    GHA(165),
    GIB(166),
    GRD(167),
    GRL(168),
    GEO(169),
    GLP(170),
    GUM(171),
    GTM(172),
    GIN(173),
    GNB(174),
    GGY(175),
    GUY(176),
    HTI(177),
    HMD(178),
    HND(179),
    HKG(180),
    CHL(181),
    HRV(182),
    IND(183),
    IDN(184),
    IRQ(185),
    IRN(186),
    IRL(187),
    ISL(188),
    ITA(189),
    ISR(190),
    JAM(191),
    JPN(192),
    YEM(193),
    JEY(194),
    ZAF(195),
    SGS(196),
    KOR(197),
    SSD(198),
    JOR(199),
    CYM(200),
    KHM(201),
    CMR(202),
    CAN(203),
    CPV(204),
    QAT(205),
    KAZ(206),
    KEN(207),
    KIR(208),
    CCK(209),
    COL(210),
    COM(211),
    COG(212),
    CRI(213),
    CUB(214),
    KWT(215),
    CYP(216),
    KGZ(217),
    LAO(218),
    LSO(219),
    LBN(220),
    LBR(221),
    LBY(222),
    LIE(223),
    LTU(224),
    LVA(225),
    LUX(226),
    MAC(227),
    MDG(228),
    HUN(229),
    MKD(230),
    MYS(231),
    MWI(232),
    MDV(233),
    MLI(234),
    MLT(235),
    IMN(236),
    MAR(237),
    MHL(238),
    MTQ(239),
    MUS(240),
    MRT(241),
    MYT(242),
    UMI(243),
    MEX(244),
    FSM(245),
    MDA(246),
    MCO(247),
    MNG(248),
    MSR(249),
    MOZ(250),
    MMR(251),
    NAM(252),
    NRU(253),
    DEU(254),
    NPL(255),
    NER(256),
    NGA(257),
    NIC(258),
    NIU(259),
    NLD(260),
    NFK(261),
    NOR(262),
    NCL(263),
    NZL(264),
    OMN(265),
    PAK(266),
    PLW(267),
    PSE(268),
    PAN(269),
    PNG(270),
    PRY(271),
    PER(272),
    PCN(273),
    CIV(274),
    POL(275),
    PRI(276),
    PRT(277),
    AUT(278),
    REU(279),
    GNQ(280),
    ROU(281),
    RUS(282),
    RWA(283),
    GRC(284),
    SPM(285),
    SLV(286),
    WSM(287),
    SMR(288),
    SAU(289),
    SEN(290),
    PRK(291),
    MNP(292),
    SYC(293),
    SLE(294),
    SGP(295),
    SVN(297),
    SOM(298),
    ARE(299),
    GBR(300),
    USA(301),
    SRB(302),
    CAF(303),
    SDN(304),
    SUR(305),
    SHN(306),
    LCA(307),
    BLM(308),
    KNA(309),
    MAF(310),
    SXM(311),
    STP(312),
    VCT(313),
    SWZ(314),
    SYR(315),
    SLB(316),
    ESP(317),
    SJM(318),
    LKA(319),
    SWE(320),
    CHE(321),
    TJK(322),
    TZA(323),
    THA(324),
    TWN(325),
    TGO(326),
    TKL(327),
    TON(328),
    TTO(329),
    TUN(330),
    TUR(331),
    TKM(332),
    TCA(333),
    TUV(334),
    UGA(335),
    UKR(336),
    URY(337),
    UZB(338),
    CXR(339),
    VUT(340),
    VAT(341),
    VEN(342),
    VNM(343),
    TLS(344),
    WLF(345),
    ZMB(346),
    ESH(347),
    ZWE(348),
    UNK(345);

    private final int position;
    private static Map<String, Locale> localeMap;

    private CountryCode(int position) {
        this.position = position;
    }

    public String toIso3() {
        return String.valueOf((Object)this);
    }

    public String toIso2() {
        return CountryCode.fromIso3ToIso2(String.valueOf((Object)this));
    }

    private static void initCountryCodeMapping() {
        String[] countries = Locale.getISOCountries();
        localeMap = new HashMap<String, Locale>(countries.length);
        for (String country : countries) {
            Locale locale = new Locale("", country);
            localeMap.put(locale.getISO3Country().toUpperCase(), locale);
        }
    }

    public static String fromIso3ToIso2(String iso3CountryCode) {
        Locale loc;
        String result;
        if (localeMap == null) {
            CountryCode.initCountryCodeMapping();
        }
        if ((result = (loc = localeMap.get(iso3CountryCode)).getCountry()) == null) {
            throw new IllegalArgumentException("not supported country [" + iso3CountryCode + "]");
        }
        return result;
    }

    public static CountryCode fromCodeStrict(String countryCode) {
        if (countryCode == null) {
            return null;
        }
        for (CountryCode country : CountryCode.values()) {
            if (!String.valueOf((Object)country).equalsIgnoreCase(countryCode)) continue;
            return country;
        }
        return null;
    }

    public static CountryCode fromAlpha2Code(String code) {
        Locale locale = new Locale("", code);
        CountryCode result = CountryCode.fromCodeStrict(locale.getISO3Country());
        if (result == null) {
            throw new IllegalArgumentException("not supported country");
        }
        return result;
    }

    public int getPosition() {
        return this.position;
    }
}

