/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3;

import cz.gopay.api.v3.model.access.AuthHeader;
import cz.gopay.api.v3.model.common.Currency;
import cz.gopay.api.v3.model.eet.EETReceipt;
import cz.gopay.api.v3.model.eet.EETReceiptFilter;
import cz.gopay.api.v3.model.payment.BasePayment;
import cz.gopay.api.v3.model.payment.CapturePayment;
import cz.gopay.api.v3.model.payment.Card;
import cz.gopay.api.v3.model.payment.NextPayment;
import cz.gopay.api.v3.model.payment.Payment;
import cz.gopay.api.v3.model.payment.PaymentResult;
import cz.gopay.api.v3.model.payment.RefundPayment;
import cz.gopay.api.v3.model.payment.support.AccountStatement;
import cz.gopay.api.v3.model.payment.support.PaymentInstrumentRoot;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

public interface PaymentClient {
    @POST
    @Path(value="/payments/payment")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public Payment createPayment(@BeanParam AuthHeader var1, BasePayment var2);

    @POST
    @Path(value="/payments/payment/{id}/refund")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public PaymentResult refundPayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2, @FormParam(value="amount") Long var3);

    @POST
    @Path(value="/payments/payment/{id}/refund")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public PaymentResult refundPayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2, RefundPayment var3);

    @POST
    @Path(value="/payments/payment/{id}/create-recurrence")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/xml"})
    public Payment createRecurrentPayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2, NextPayment var3);

    @POST
    @Path(value="/payments/payment/{id}/void-recurrence")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public PaymentResult voidRecurrence(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2);

    @POST
    @Path(value="/payments/payment/{id}/capture")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public PaymentResult capturePayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2);

    @POST
    @Path(value="/payments/payment/{id}/capture")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public PaymentResult capturePayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2, CapturePayment var3);

    @POST
    @Path(value="/payments/payment/{id}/void-authorization")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public PaymentResult voidAuthorization(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2);

    @GET
    @Path(value="/payments/payment/{id}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Payment getPayment(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2);

    @GET
    @Path(value="eshops/eshop/{goid}/payment-instruments/{currency}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public PaymentInstrumentRoot getPaymentInstruments(@BeanParam AuthHeader var1, @PathParam(value="goid") Long var2, @PathParam(value="currency") Currency var3);

    @POST
    @Path(value="accounts/account-statement")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public byte[] getStatement(@BeanParam AuthHeader var1, AccountStatement var2);

    @POST
    @Path(value="/eet-receipts")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public List<EETReceipt> findEETReceiptsByFilter(@BeanParam AuthHeader var1, EETReceiptFilter var2);

    @GET
    @Path(value="/payments/payment/{id}/eet-receipts")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public List<EETReceipt> getEETReceiptByPaymentId(@BeanParam AuthHeader var1, @PathParam(value="id") Long var2);

    @GET
    @Path(value="/payments/cards/{card_id}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json"})
    public Card getCardDetail(@BeanParam AuthHeader var1, @PathParam(value="card_id") Long var2);

    @DELETE
    @Path(value="payments/cards/{card_id}")
    public void deleteCard(@BeanParam AuthHeader var1, @PathParam(value="card_id") Long var2);
}

