/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.payment.support;

import cz.gopay.api.v3.Builder;
import cz.gopay.api.v3.model.payment.support.Payer;
import cz.gopay.api.v3.model.payment.support.PayerContact;
import cz.gopay.api.v3.model.payment.support.PaymentInstrument;
import java.util.ArrayList;
import java.util.List;

public class PayerBuilder
implements Builder<Payer> {
    private PaymentInstrument paymentInstrument;
    private PaymentInstrument defaultPaymentInstrument;
    private List<PaymentInstrument> allowedPaymentInstruments = new ArrayList<PaymentInstrument>();
    private List<String> allowedSwifts = new ArrayList<String>();
    private List<String> allowedBnplTypes = new ArrayList<String>();
    private String defaultBnplType = "";
    private PayerContact contact;
    private String allowedCardToken;
    private String verifyPin;
    private Boolean requestCardToken;
    private String maskedPan;

    @Override
    public Payer build() {
        Payer payer = new Payer();
        payer.setAllowedPaymentInstruments(this.allowedPaymentInstruments);
        payer.setDefaultPaymentInstrument(this.defaultPaymentInstrument);
        payer.setContact(this.contact);
        payer.setAllowedSwifts(this.allowedSwifts);
        payer.setPaymentInstrument(this.paymentInstrument);
        payer.setAllowedCardToken(this.allowedCardToken);
        payer.setVerifyPin(this.verifyPin);
        payer.setRequestCardToken(this.requestCardToken);
        payer.setMaskedPan(this.maskedPan);
        payer.setAllowedBnplTypes(this.allowedBnplTypes);
        payer.setDefaultBnplType(this.defaultBnplType);
        return payer;
    }

    public PayerBuilder withPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    public PayerBuilder withDefaultPaymentInstrument(PaymentInstrument defaultPaymentInstrument) {
        this.defaultPaymentInstrument = defaultPaymentInstrument;
        return this;
    }

    public PayerBuilder withAllowedPaymentInstruments(List<PaymentInstrument> allowedInstruments) {
        this.allowedPaymentInstruments = allowedInstruments;
        return this;
    }

    public PayerBuilder addAllowedPaymentMethod(PaymentInstrument allowedInstrument) {
        if (this.allowedPaymentInstruments == null) {
            this.allowedPaymentInstruments = new ArrayList<PaymentInstrument>();
        }
        this.allowedPaymentInstruments.add(allowedInstrument);
        return this;
    }

    public PayerBuilder withAllowedSwifts(List<String> allowedSwifts) {
        this.allowedSwifts = allowedSwifts;
        return this;
    }

    public PayerBuilder addAllowedSwift(String allowedSwift) {
        if (this.allowedSwifts == null) {
            this.allowedSwifts = new ArrayList<String>();
        }
        this.allowedSwifts.add(allowedSwift);
        return this;
    }

    public PayerBuilder withContactData(PayerContact contact) {
        this.contact = contact;
        return this;
    }

    public PayerBuilder withAllowedCardToken(String cardToken) {
        this.allowedCardToken = cardToken;
        return this;
    }

    public PayerBuilder withVerificationPin(String verificationPin) {
        this.verifyPin = verificationPin;
        return this;
    }

    public PayerBuilder withRequestCardToken(Boolean requestCardToken) {
        this.requestCardToken = requestCardToken;
        return this;
    }

    public PayerBuilder withMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
        return this;
    }

    public PayerBuilder withAllowedBnplTypes(List<String> allowedBnplTypes) {
        this.allowedBnplTypes = allowedBnplTypes;
        return this;
    }

    public PayerBuilder addDefaultBnplType(String defaultBnplType) {
        this.defaultBnplType = defaultBnplType;
        return this;
    }
}

