/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.model.payment.support;

import cz.gopay.api.v3.model.common.CheckoutGroup;
import cz.gopay.api.v3.model.payment.support.Bnpl;
import cz.gopay.api.v3.model.payment.support.Image;
import cz.gopay.api.v3.model.payment.support.PaymentInstrument;
import cz.gopay.api.v3.model.payment.support.Swift;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EnabledPaymentInstrument {
    private PaymentInstrument paymentInstrument;
    private Map<Locale, String> label;
    private Image image;
    private String group;
    private List<Swift> enabledSwifts;
    private List<Bnpl> enabledBnplTypes;

    private EnabledPaymentInstrument() {
    }

    private EnabledPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    public static EnabledPaymentInstrument init(PaymentInstrument paymentInstrument) {
        return new EnabledPaymentInstrument(paymentInstrument);
    }

    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    public Map<Locale, String> getLabel() {
        return this.label;
    }

    public EnabledPaymentInstrument addLabel(String label, Locale locale) {
        if (this.label == null) {
            this.label = new LinkedHashMap<Locale, String>();
        }
        this.label.put(locale, label);
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public EnabledPaymentInstrument withImage(Image image) {
        this.image = image;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public EnabledPaymentInstrument withGroup(CheckoutGroup coGroup) {
        this.group = coGroup.getName();
        return this;
    }

    public List<Swift> getEnabledSwifts() {
        return this.enabledSwifts;
    }

    public EnabledPaymentInstrument addEnabledSwift(Swift swift) {
        if (this.enabledSwifts == null) {
            this.enabledSwifts = new ArrayList<Swift>();
        }
        this.enabledSwifts.add(swift);
        return this;
    }

    public List<Bnpl> getEnabledBnplTypes() {
        return this.enabledBnplTypes;
    }

    public EnabledPaymentInstrument addEnabledBnplType(Bnpl bnplType) {
        if (this.enabledBnplTypes == null) {
            this.enabledBnplTypes = new ArrayList<Bnpl>();
        }
        this.enabledBnplTypes.add(bnplType);
        return this;
    }

    public void setEnabledBnplTypes(List<Bnpl> enabledBnplTypes) {
        this.enabledBnplTypes = enabledBnplTypes;
    }

    public String toString() {
        return String.format("EnabledPaymentInstrument: [paymentInstrument=%s, label=%s, image=%s, group=%s, enabledSwifts=%s, enabledBnplTypes=%s]\n", new Object[]{this.paymentInstrument, this.label, this.image, this.group, this.enabledSwifts, this.enabledBnplTypes});
    }
}

