/*
 * Decompiled with CFR 0.152.
 */
package cz.gopay.api.v3.impl.resteasy;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import cz.gopay.api.v3.AbstractGPConnector;
import cz.gopay.api.v3.model.access.AccessToken;
import cz.gopay.api.v3.model.access.OAuth;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyGPConnector
extends AbstractGPConnector {
    private ResteasyGPConnector(String api) {
        super(api);
    }

    private ResteasyGPConnector(String api, AccessToken accessToken) {
        super(api, accessToken);
    }

    private ResteasyGPConnector(String api, AccessToken accessToken, String customUserAgent) {
        super(api, accessToken, customUserAgent);
    }

    public static ResteasyGPConnector build(String api) {
        return new ResteasyGPConnector(api);
    }

    public static ResteasyGPConnector build(String api, AccessToken accessToken, String customerUserAgent) {
        return new ResteasyGPConnector(api, accessToken, customerUserAgent);
    }

    public static ResteasyGPConnector build(String api, String accessToken, String refreshToken, Date expiresIn) {
        return new ResteasyGPConnector(api, new AccessToken(OAuth.TOKEN_TYPE_BEARER, accessToken, refreshToken, expiresIn.getTime()));
    }

    protected <T> T createRESTClientProxy(String apiUrl, Class<T> proxy) {
        URI i = null;
        try {
            i = new URI(apiUrl);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        ResteasyClientBuilderImpl builder = new ResteasyClientBuilderImpl();
        builder.connectTimeout((long)CONNECTION_SETUP_TO, TimeUnit.SECONDS);
        builder.readTimeout((long)CONNECTION_SETUP_TO, TimeUnit.SECONDS);
        ResteasyProviderFactory.getInstance().register((Object)builder);
        ResteasyClientImpl client = (ResteasyClientImpl)builder.build();
        client.register(requestContext -> requestContext.getHeaders().add((Object)"User-Agent", (Object)(this.getImplementationName() + " " + this.getVersion())));
        ObjectMapper mapper = new ObjectMapper();
        JacksonJaxbJsonProvider jaxbProvider = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        builder.register((Object)jaxbProvider);
        ResteasyWebTarget target = client.target(i);
        return (T)target.proxy(proxy);
    }

    public String getImplementationName() {
        return this.customUserAgent == null ? "GoPay Java Resteasy" : this.customUserAgent;
    }
}

