/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.jasper;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import cz.i24.util.jasper.ClassPathFileResolver;
import cz.i24.util.jasper.QRCodeColored;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.util.FileResolver;

public final class RU {
    public static final String DATE_FORMAT = "dd.MM.yyyy";
    public static final String NUMBER_FORMAT = "#,##0.00;-#,##0.00";
    public static final String DECIMAL_FORMAT = "#,##0;-#,##0";
    public static final String DIVIDED_BY_ZERO_VALUE = "--";
    public static final String TAB = "_______";
    public static final String NBSP = "_";
    public static final String BASE_FONT = "Helvetica";
    public static final String CHECKBOX_CHECKED = "X";
    public static final String CHECKBOX_NOT_CHECKED = " ";
    public static final int MATH_ROUND = 0;
    public static final int MATH_FLOOR = -1;
    public static final int MATH_CEIL = 1;
    public static final int VERSION_LEVEL = 3;
    public static Locale defaultLocale = new Locale("cs", "CZ");

    private RU() {
    }

    public static QRCodeColored getQRCodeColored(String text, int width, int onColor, int offColor) {
        return QRCodeColored.from(text).to("PNG").withErrorCorrection(ErrorCorrectionLevel.M).withSize(width, width).withColor(onColor, offColor);
    }

    public static InputStream qr(String text, int width, int onColor, int offColor) {
        return new ByteArrayInputStream(RU.getQRCodeColored(text, width, onColor, offColor).stream().toByteArray());
    }

    public static String formatDate(Date date, String mask) {
        if (date == null) {
            return "";
        }
        if (mask == null) {
            mask = DATE_FORMAT;
        }
        return new SimpleDateFormat(mask).format(date);
    }

    public static String formatDate(Date date) {
        return RU.formatDate(date, null);
    }

    public static Date date(Object date) {
        return RU.date(date, DATE_FORMAT);
    }

    public static Date date(Object date, String mask) {
        if (mask == null) {
            mask = DATE_FORMAT;
        }
        if (date == null || date instanceof Date) {
            return (Date)date;
        }
        SimpleDateFormat format = new SimpleDateFormat(mask);
        try {
            return format.parse(date.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatNumber(Number value, String mask, double round) {
        double val = 0.0;
        if (value != null) {
            val = value.doubleValue();
        }
        return RU.formatNumber(val, mask, round);
    }

    public static String formatNumber(double value, String mask, double round) {
        if (mask == null) {
            mask = NUMBER_FORMAT;
        }
        if (round < 0.0) {
            value = (double)Math.round(value / round) * round;
        } else {
            String ma;
            double rounding = 10.0;
            if (mask.lastIndexOf(".") > 0 && (ma = mask.substring(mask.lastIndexOf(".") + 1)).length() > 0) {
                double len = ma.length();
                rounding = Math.pow(rounding, len);
                value = (double)Math.round(value * rounding) / rounding;
            }
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(defaultLocale);
        DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(symbols);
        df.applyPattern(mask);
        return df.format(value);
    }

    public static Object json(Object data, String hierarchy) {
        if (!(data instanceof JsonNode) || RU.isBlank(hierarchy)) {
            return null;
        }
        try {
            String part;
            String[] parts = hierarchy.split("[.]");
            JsonNode actual = (JsonNode)data;
            String[] stringArray = parts;
            int n = stringArray.length;
            for (int i = 0; i < n && (actual = actual.get(part = stringArray[i])) != null; ++i) {
            }
            if (actual != null) {
                if (actual.isArray()) {
                    ArrayList<JsonNode> dataList = new ArrayList<JsonNode>();
                    for (JsonNode objNode : actual) {
                        dataList.add(objNode);
                    }
                    return dataList;
                }
                if (actual.isNull()) {
                    return null;
                }
                if (actual.isBigDecimal() || actual.isDouble() || actual.isFloatingPointNumber() || actual.isNumber()) {
                    return actual.decimalValue();
                }
                if (actual.isBigInteger() || actual.isInt() || actual.isLong() || actual.isIntegralNumber()) {
                    return actual.longValue();
                }
                return actual.asText();
            }
        }
        catch (Exception e) {
            return hierarchy;
        }
        return null;
    }

    public static String formatNumber(Number value) {
        return RU.formatNumber(value, 0.0);
    }

    public static String formatNumber(Number value, double round) {
        return RU.formatNumber(value, null, round);
    }

    public static String formatNumber(Number value, String mask) {
        return RU.formatNumber(value, mask, 0.0);
    }

    public static String formatNumber(double value, String mask) {
        return RU.formatNumber(value, mask, 0.0);
    }

    public static String formatNumber(double value, double round) {
        return RU.formatNumber(value, null, 0.0);
    }

    public static String format(Object obj, String mask, double round) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return RU.formatDate((Date)obj, mask);
        }
        if (obj instanceof Number) {
            return RU.formatNumber((Number)obj, mask, round);
        }
        return obj.toString();
    }

    public static String format(Object obj) {
        return RU.format(obj, 0.0);
    }

    public static String format(Object obj, double round) {
        return RU.format(obj, null, round);
    }

    public static String format(Object obj, String mask) {
        return RU.format(obj, mask, 0.0);
    }

    public static String f(Object obj) {
        return RU.format(obj);
    }

    public static String fd(Object obj) {
        return RU.format(obj, DECIMAL_FORMAT);
    }

    public static String f(Object obj, String mask) {
        return RU.format(obj, mask);
    }

    public static String f(Object obj, double round) {
        return RU.format(obj, round);
    }

    public static String f(Object obj, String mask, double round) {
        return RU.format(obj, mask, round);
    }

    @Deprecated
    public static String getStringFromDate(Date date) {
        return RU.formatDate(date);
    }

    public static String w(Object printWhen, Object value) {
        return RU.when(printWhen, value);
    }

    public static String wn(Object printWhen, Object value) {
        return RU.whenNot(printWhen, value);
    }

    public static String when(Object printWhen, Object value) {
        return RU.nn(RU.printWhen(printWhen, value));
    }

    public static String whenNot(Object printWhen, Object value) {
        return RU.nn(RU.printWhenNot(printWhen, value));
    }

    public static Object printWhen(Object printWhen, Object value) {
        if (RU.asBool(printWhen) == null) {
            return null;
        }
        return Boolean.TRUE.equals(RU.asBool(printWhen)) ? value : null;
    }

    public static Object printWhenNot(Object printWhen, Object value) {
        if (RU.asBool(printWhen) == null) {
            return null;
        }
        return Boolean.TRUE.equals(RU.asBool(printWhen)) ? null : value;
    }

    public static String getWithFirstUpperCase(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 1) {
            return string.substring(0, 1).toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static Date calculateTimeDifference(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return null;
        }
        return new Date(endTime.getTime() - startTime.getTime());
    }

    public static String substringRight(String s, int chars) {
        if (s == null) {
            return "";
        }
        if (s.length() > chars) {
            s = s.subSequence(s.length() - chars, s.length()).toString();
        }
        return s;
    }

    public static String getLetterFromPosition(String s, int position) {
        s = s == null ? "" : (position <= s.length() ? s.substring(position - 1, position) : "");
        return s;
    }

    public static Integer getMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Integer(cal.get(2) + 1);
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Integer(cal.get(1));
    }

    public static Integer getDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Integer(cal.get(5));
    }

    public static String nn(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String nn(Object object, Object defaultString) {
        if (object == null || object.toString().isEmpty()) {
            return defaultString == null ? "" : defaultString.toString();
        }
        return object.toString();
    }

    @Deprecated
    public static String blank(Object object) {
        return RU.nn(object);
    }

    public static String percentageOf(Number value, Number base) {
        return RU.percentageOf(value, base, null);
    }

    public static String percentageOf(Number value, Number base, String mask) {
        if (base == null || base.doubleValue() == 0.0) {
            return DIVIDED_BY_ZERO_VALUE;
        }
        if (value == null) {
            return RU.formatNumber(0.0, mask);
        }
        return RU.formatNumber(value.doubleValue() / base.doubleValue() * 100.0, mask);
    }

    public static String dateDifference(Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        long diffInMillis = endCal.getTimeInMillis() - startCal.getTimeInMillis();
        long hours = diffInMillis / 3600000L;
        long minutes = diffInMillis % 3600000L / 60000L;
        long seconds = diffInMillis % 3600000L % 60000L / 1000L;
        String secondsStr = (seconds < 10L ? "0" : "") + seconds;
        String minutesStr = (minutes < 10L ? "0" : "") + minutes;
        String hoursStr = (hours < 10L ? "0" : "") + hours;
        return hoursStr + ":" + minutesStr + ":" + secondsStr;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isBlank(Object o) {
        if (o == null) {
            return true;
        }
        return o.toString().length() == 0;
    }

    public static String black(Object o) {
        return RU.font("black", RU.nn(o));
    }

    public static String red(Object o) {
        return RU.font("red", RU.nn(o));
    }

    public static String blue(Object o) {
        return RU.font("blue", RU.nn(o));
    }

    public static String green(Object o) {
        return RU.font("green", RU.nn(o));
    }

    public static String yellow(Object o) {
        return RU.font("yellow", RU.nn(o));
    }

    public static String pink(Object o) {
        return RU.font("pink", RU.nn(o));
    }

    public static String cyan(Object o) {
        return RU.font("cyan", RU.nn(o));
    }

    public static String white(Object o) {
        return RU.font("white", RU.nn(o));
    }

    public static String orange(Object o) {
        return RU.font("orange", RU.nn(o));
    }

    public static String silver(Object o) {
        return RU.font("silver", RU.nn(o));
    }

    public static String nc(Object o) {
        return RU.font("#D16B1B", RU.nn(o));
    }

    public static String li() {
        return RU.white("___") + RU.style("wingding", "\u00fa") + CHECKBOX_NOT_CHECKED;
    }

    public static String i(Object o) {
        return RU.tag("i", RU.nn(o));
    }

    public static String b(Object o) {
        return RU.tag("b", RU.nn(o));
    }

    public static String u(Object o) {
        return RU.tag("u", RU.nn(o));
    }

    public static String s(Object original, Boolean striked) {
        return RU.s(original, striked, RU.nn(original).length() <= 3);
    }

    public static String s(Object original, Boolean striked, Boolean addSpaces) {
        if (original == null) {
            return "";
        }
        String space = "";
        if (Boolean.TRUE.equals(addSpaces)) {
            space = CHECKBOX_NOT_CHECKED;
        }
        return "<style" + (Boolean.TRUE.equals(striked) ? " isStrikeThrough=\"true\"" : "") + ">" + space + RU.nn(original) + space + "</style>";
    }

    public static String u(Object o, Boolean striked) {
        return Boolean.TRUE.equals(striked) ? RU.u(o) : RU.nn(o);
    }

    public static String bi(Object o) {
        return RU.tag("i", RU.tag("b", RU.nn(o)));
    }

    @Deprecated
    public static String italic(Object o) {
        return RU.i(o);
    }

    @Deprecated
    public static String bold(Object o) {
        return RU.b(o);
    }

    @Deprecated
    public static String underline(Object o) {
        return RU.u(o);
    }

    @Deprecated
    public static String boldItalic(Object o) {
        return RU.bi(o);
    }

    public static String color(String color, String original) {
        return RU.font(color, original);
    }

    public static String rgb(String color, String original) {
        return RU.font(color, original);
    }

    public static String font(String color, String original) {
        if (original == null) {
            return "";
        }
        return "<font color=\"" + color + "\">" + original + "</font>";
    }

    public static String tag(String name, String original) {
        if (original == null) {
            return "";
        }
        return "<" + name + ">" + original + "</" + name + ">";
    }

    public static String tab() {
        return RU.white(TAB);
    }

    public static String paragraph(int size) {
        return "\n<font size=\"" + size + "\" color=\"white\">X</font>\n";
    }

    public static String paragraph() {
        return RU.paragraph(4);
    }

    public static String paragraph(String text) {
        return RU.paragraph(text, 4);
    }

    public static String paragraph(String text, int size) {
        String[] separated;
        String preparedText = "";
        if (text == null) {
            return preparedText;
        }
        for (String par : separated = text.split("\n\t")) {
            preparedText = preparedText + par + RU.paragraph(size);
        }
        return preparedText;
    }

    public static String tab(String text) {
        return RU.white(text);
    }

    public static String n() {
        return RU.white(NBSP);
    }

    public static String nbsp() {
        return RU.white(NBSP);
    }

    public static String nbsp(String color) {
        return RU.font(color, NBSP);
    }

    public static String style(String pdfFontName, String original, int size) {
        return RU.style(pdfFontName, original, size, true);
    }

    public static Object get(List<?> collection, int index) {
        if (collection == null || collection.isEmpty() || index < 0 || index >= collection.size()) {
            return null;
        }
        return collection.get(index);
    }

    public static String style(String pdfFontName, String original, int size, boolean trueType) {
        if (original == null) {
            return "";
        }
        if (pdfFontName == null) {
            return "";
        }
        String finalString = "<style pdfFontName=\"" + pdfFontName.toLowerCase() + "." + (trueType ? "ttf" : "otf") + "\"";
        if (size > 0) {
            finalString = finalString + " size=\"" + size + "\"";
        }
        finalString = finalString + ">" + original + "</style>";
        return finalString;
    }

    public static String style(String pdfFontName, String original) {
        return RU.style(pdfFontName, original, -1, true);
    }

    public static String style(String pdfFontName, String original, boolean trueType) {
        return RU.style(pdfFontName, original, -1, trueType);
    }

    public static String b(String baseFontName, String original, int size) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bd", original, size, true);
    }

    public static String b(String baseFontName, String original, int size, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bd", original, size, trueType);
    }

    public static String b(String baseFontName, String original) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bd", original, -1, true);
    }

    public static String b(String baseFontName, String original, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bd", original, -1, trueType);
    }

    public static String i(String baseFontName, String original, int size) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "i", original, size, true);
    }

    public static String i(String baseFontName, String original, int size, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "i", original, size, trueType);
    }

    public static String sup(String original) {
        return RU.tag("sup", original);
    }

    public static String sub(String original) {
        return RU.tag("sub", original);
    }

    public static String i(String baseFontName, String original) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "i", original, -1, true);
    }

    public static String i(String baseFontName, String original, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "i", original, -1, trueType);
    }

    public static String bi(String baseFontName, String original, int size) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bi", original, size, true);
    }

    public static String bi(String baseFontName, String original, int size, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bi", original, size, trueType);
    }

    public static String bi(String baseFontName, String original) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bi", original, -1, true);
    }

    public static String bi(String baseFontName, String original, boolean trueType) {
        if (baseFontName == null) {
            baseFontName = BASE_FONT;
        }
        return RU.style(baseFontName + "bi", original, -1, trueType);
    }

    public static String checkbox(Boolean value) {
        if (value != null && value.booleanValue()) {
            return CHECKBOX_CHECKED;
        }
        return CHECKBOX_NOT_CHECKED;
    }

    public static String checkbox(Object dbValue, String value) {
        if (dbValue != null && value != null && value.equals(String.valueOf(dbValue))) {
            return CHECKBOX_CHECKED;
        }
        return CHECKBOX_NOT_CHECKED;
    }

    public static Number math(Number num, double decimals, int type) {
        Number ret = num;
        if (num instanceof BigDecimal) {
            ret = new BigDecimal(RU.round(num.doubleValue() / decimals, type) * decimals);
        } else if (num instanceof Double) {
            ret = new Double(RU.round(num.doubleValue() / decimals, type) * decimals);
        } else if (num instanceof Float) {
            ret = new Float(RU.round(num.doubleValue() / decimals, type) * decimals);
        }
        return ret;
    }

    private static double round(double d, int type) {
        double returnVal = d;
        switch (type) {
            case -1: {
                returnVal = Math.floor(d);
                break;
            }
            case 1: {
                returnVal = Math.ceil(d);
                break;
            }
            default: {
                returnVal = Math.round(d);
            }
        }
        return returnVal;
    }

    public static String barCode39(String value) {
        if (value == null) {
            value = "";
        }
        String retVal = "";
        for (int i = 0; i < value.length(); ++i) {
            retVal = retVal + value.charAt(i) + CHECKBOX_NOT_CHECKED;
        }
        retVal = "* " + retVal + "*";
        return retVal;
    }

    public static String message(String[] messages, Number index) {
        if (index == null || messages == null) {
            return "";
        }
        if (index.intValue() > messages.length) {
            return "";
        }
        return messages[index.intValue()];
    }

    public static String message(String[] messages, int[] indexes, Number index) {
        if (index == null || messages == null) {
            return "";
        }
        int finalIndex = -1;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] != index.intValue()) continue;
            finalIndex = i;
        }
        if (finalIndex == -1) {
            return "";
        }
        return messages[finalIndex];
    }

    public static String dateToAcc(Date date) {
        if (date == null) {
            return "";
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1) + "." + RU.addZerosBefore("" + (cal.get(2) + 1), 2);
    }

    public static String monthAdd(String acc, int months) {
        if (acc == null) {
            return "";
        }
        int year = Integer.valueOf(acc.substring(0, 4));
        int month = Integer.valueOf(acc.substring(5)) - 1;
        int day = 1;
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        ((Calendar)cal).add(2, months);
        return cal.get(1) + "." + RU.addZerosBefore("" + (cal.get(2) + 1), 2);
    }

    public static String addZerosBefore(String orderNo, int count) {
        if (orderNo == null) {
            return "";
        }
        if (orderNo.length() > count) {
            orderNo = "?" + orderNo.substring(orderNo.length() - count - 1, orderNo.length() - 1);
        } else {
            int le = orderNo.length();
            for (int i = 0; i < count - le; ++i) {
                orderNo = "0" + orderNo;
            }
        }
        return orderNo;
    }

    public static String ts(String separator, Object ... data) {
        return RU.tokens(separator, data);
    }

    public static String tokens(String separator, Object ... data) {
        if (data == null || data.length == 0 || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean separate = false;
        for (Object token : data) {
            if (RU.nn(token).trim().length() == 0) continue;
            if (separate) {
                sb.append(separator);
            } else {
                separate = true;
            }
            sb.append(RU.nn(token));
        }
        return sb.toString();
    }

    public static Object getResource(FileResolver fileResolver, String filename) {
        if (fileResolver == null || !(fileResolver instanceof ClassPathFileResolver)) {
            return filename;
        }
        for (String path : ((ClassPathFileResolver)fileResolver).getClassPath()) {
            InputStream is = RU.class.getResourceAsStream(path + "/" + filename);
            if (is == null) continue;
            return is;
        }
        return filename;
    }

    public static String bool(Object value, String trueValue, String falseValue) {
        Boolean valueBool = RU.asBool(value);
        if (valueBool == null) {
            return null;
        }
        return Boolean.TRUE.equals(RU.asBool(value)) ? trueValue : falseValue;
    }

    public static Boolean asBool(Object value) {
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        Boolean valueBool = null;
        if (value instanceof String) {
            valueBool = Boolean.valueOf(value.toString());
        } else if (value instanceof Boolean) {
            valueBool = (Boolean)value;
        } else {
            return null;
        }
        return valueBool;
    }

    public static boolean isTrue(Object value) {
        return RU.isTrue(value, false);
    }

    public static boolean isTrue(Object value, boolean defaultValue) {
        Boolean val = RU.asBool(value);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public static boolean isFalse(Object value, boolean defaultValue) {
        Boolean val = RU.asBool(value);
        if (val == null) {
            return defaultValue;
        }
        return val == false;
    }

    public static boolean isFalse(Object value) {
        return !RU.isFalse(value, true);
    }

    public static boolean and(Object value, Object value1) {
        return RU.isTrue(value) && RU.isTrue(value1);
    }

    public static boolean or(Object value, Object value1) {
        return RU.isTrue(value) || RU.isTrue(value1);
    }

    public static boolean not(Object value) {
        return !RU.isTrue(value);
    }
}

