/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.jasper;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class QRCodeColored {
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final String JPG = "JPG";
    public static final String GIF = "GIF";
    public static final String PNG = "PNG";
    private final HashMap<EncodeHintType, Object> hints = new HashMap();
    private Writer qrWriter = new QRCodeWriter();
    private int width = 125;
    private int height = 125;
    private String imageType = "PNG";
    private int onColor = -16777216;
    private int offColor = -1;
    private String text;

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public static QRCodeColored from(String text) {
        QRCodeColored instance = new QRCodeColored();
        instance.text = text;
        return instance;
    }

    public QRCodeColored withErrorCorrection(ErrorCorrectionLevel level) {
        return this.withHint(EncodeHintType.ERROR_CORRECTION, level);
    }

    public QRCodeColored withHint(EncodeHintType hintType, Object value) {
        this.hints.put(hintType, value);
        return this;
    }

    public QRCodeColored withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public QRCodeColored withColor(int onColor, int offColor) {
        this.onColor = onColor;
        this.offColor = offColor;
        return this;
    }

    private BitMatrix createMatrix() throws WriterException {
        return this.qrWriter.encode(this.text, BarcodeFormat.QR_CODE, this.width, this.height, this.hints);
    }

    private void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream((BitMatrix)this.createMatrix(), (String)this.imageType, (OutputStream)stream, (MatrixToImageConfig)new MatrixToImageConfig(this.onColor, this.offColor));
    }

    public ByteArrayOutputStream stream() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeTo(stream);
        return stream;
    }

    public void writeTo(OutputStream stream) {
        try {
            this.writeToStream(stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("QRCode genertate", e);
        }
    }

    public QRCodeColored to(String imageType) {
        this.imageType = imageType;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public HashMap<EncodeHintType, Object> getHints() {
        return this.hints;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getOnColor() {
        return this.onColor;
    }

    public void setOnColor(int onColor) {
        this.onColor = onColor;
    }

    public int getOffColor() {
        return this.offColor;
    }

    public void setOffColor(int offColor) {
        this.offColor = offColor;
    }
}

