/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.log;

import cz.i24.util.log.AutomaticToString;
import cz.i24.util.log.MethodLoggerObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodLoggerAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodLoggerAspect.class);

    public Object logMethod(ProceedingJoinPoint pjp) throws Throwable {
        if (LOG.isDebugEnabled()) {
            Method method = ((MethodSignature)pjp.getSignature()).getMethod();
            Object[] args = pjp.getArgs();
            MethodLoggerAspect.logBefore(method, args);
        }
        Object retVal = pjp.proceed();
        if (LOG.isDebugEnabled()) {
            Method method = ((MethodSignature)pjp.getSignature()).getMethod();
            MethodLoggerAspect.logAfter(method, retVal);
        }
        return retVal;
    }

    public static void logBefore(Method method, Object[] args) {
        if (args.length == 0) {
            LOG.debug(MethodLoggerAspect.getMethodFullInfoPath(method) + " executed.");
        } else {
            LOG.debug(MethodLoggerAspect.getMethodFullInfoPath(method) + " executed with params: " + MethodLoggerObject.logCollectionOfObjects(Arrays.asList(method.getParameterAnnotations()), Arrays.asList(args)));
        }
    }

    public static void logAfter(Method method, Object retVal) {
        LOG.debug(MethodLoggerAspect.getMethodFullInfoPath(method) + " finished with value: " + MethodLoggerObject.logObject(method.isAnnotationPresent(AutomaticToString.class) ? "{*****}" : retVal));
    }

    public static String getMethodFullInfoPath(Method m) {
        return m.getDeclaringClass().getSimpleName() + "." + m.getName();
    }

    public static void logExceptionStatic(Throwable ex) {
        LOG.error("Not catched exception raised in application", ex);
    }

    public void logException(Throwable ex) {
        MethodLoggerAspect.logExceptionStatic(ex);
    }

    public void setAutoToString(Set<String> set) {
        MethodLoggerObject.AUTO_TO_STRING.addAll(set);
    }
}

