/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.log;

import cz.i24.util.log.MethodLoggerAspect;
import cz.i24.util.log.MethodLoggerIgnoreParamValue;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MethodLoggerObject {
    public static final String PARAMS_SEPARATOR = ", ";
    public static final String IGNORED_LOG_VALUE = "{*****}";
    public static final String FORMAT_DDMMYYY_HHMMSS = "dd.MM.yyyy HH:mm:ss";
    public static final Set<String> AUTO_TO_STRING = new HashSet<String>();

    public void logException(Exception ex) {
        MethodLoggerAspect.logExceptionStatic(ex);
    }

    public static String logObject(Object obj, boolean hideValue) {
        if (obj == null) {
            return null;
        }
        String info = obj.getClass().getSimpleName();
        if (hideValue) {
            return info + "[" + IGNORED_LOG_VALUE + "]";
        }
        if (obj instanceof Date) {
            return info + "[" + MethodLoggerObject.toString(obj) + "]";
        }
        if (obj instanceof byte[]) {
            return info + "[ byte[](" + ((byte[])obj).length + ")" + "]";
        }
        if (obj instanceof Collection) {
            return info + "[" + MethodLoggerObject.logCollectionOfObjects((Collection)obj) + "]";
        }
        if (obj instanceof Object[]) {
            return info + "[" + MethodLoggerObject.logCollectionOfObjects(Arrays.asList((Object[])obj)) + "]";
        }
        return info + "[" + MethodLoggerObject.toString(obj) + "]";
    }

    public static String toString(Object object) {
        if (object instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat(FORMAT_DDMMYYY_HHMMSS);
            return df.format(object);
        }
        String stringValue = object.toString();
        if (object instanceof Date || stringValue.startsWith(object.getClass().getName() + "@") && (MethodLoggerObject.isAutoToString(object.getClass().getAnnotations()) || Serializable.class.isAssignableFrom(object.getClass()))) {
            stringValue = ToStringBuilder.reflectionToString((Object)object, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false);
        }
        return stringValue;
    }

    protected static boolean isAutoToString(Annotation[] annotations) {
        if (ArrayUtils.isEmpty((Object[])annotations) || AUTO_TO_STRING.isEmpty()) {
            return false;
        }
        boolean isIn = false;
        for (Annotation annotation : annotations) {
            if (!AUTO_TO_STRING.contains(annotation.annotationType().getName())) continue;
            isIn = true;
            break;
        }
        return isIn;
    }

    public static String logCollectionOfObjects(List<Annotation[]> declarations, Collection<?> objs) {
        StringBuilder msg = new StringBuilder();
        int i = 0;
        for (Object o : objs) {
            if (msg.length() > 0) {
                msg.append(PARAMS_SEPARATOR);
            }
            boolean hideValue = false;
            if (declarations != null) {
                List<Object> declarationList = Arrays.asList((Object[])declarations.get(i++));
                for (Annotation annotation : declarationList) {
                    if (!annotation.annotationType().equals(MethodLoggerIgnoreParamValue.class)) continue;
                    hideValue = true;
                }
            }
            msg.append(MethodLoggerObject.logObject(o, hideValue));
        }
        return msg.toString();
    }

    public static String logCollectionOfObjects(Collection<?> objs) {
        return MethodLoggerObject.logCollectionOfObjects(null, objs);
    }

    public static String logObject(Object obj) {
        return MethodLoggerObject.logObject(obj, false);
    }
}

