/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.log.transaction;

import cz.i24.util.log.transaction.TransactionDescription;
import cz.i24.util.log.transaction.TransactionIndicatingUtil;
import java.util.Objects;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.MDC;

public class TransactionIndicatingFilter
extends Filter {
    private String ignorePackage;
    private ThreadLocal<Boolean> recursiveCheck = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decide(LoggingEvent loggingEvent) {
        Boolean isRecursiveCall = this.recursiveCheck.get();
        if (isRecursiveCall == null || !isRecursiveCall.booleanValue()) {
            try {
                this.recursiveCheck.set(Boolean.TRUE);
                MDC.remove((String)"xaName");
                MDC.remove((String)"xaStatus");
                MDC.remove((String)"xaIsolation");
                MDC.remove((String)"xaReadOnly");
                TransactionDescription desc = TransactionIndicatingUtil.getTransactionDescription();
                if (desc.getName() != null && this.ignorePackage != null && desc.getName().startsWith(this.ignorePackage)) {
                    int n = -1;
                    return n;
                }
                if (Boolean.TRUE.equals(desc.getActive())) {
                    MDC.put((String)"xaName", (String)desc.getName());
                    MDC.put((String)"xaStatus", (String)(Boolean.TRUE.equals(desc.getActive()) ? "+" : "-"));
                    MDC.put((String)"xaIsolation", (String)Objects.toString(desc.getIsolation()));
                    MDC.put((String)"xaReadOnly", (String)(Boolean.TRUE.equals(desc.getReadOnly()) ? "r" : "w"));
                }
            }
            finally {
                this.recursiveCheck.set(Boolean.FALSE);
            }
        }
        return 0;
    }

    public String getIgnorePackage() {
        return this.ignorePackage;
    }

    public void setIgnorePackage(String ignorePackage) {
        this.ignorePackage = ignorePackage;
    }
}

