/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.log.transaction;

import cz.i24.util.log.MethodLoggerObject;
import cz.i24.util.log.transaction.TransactionDescription;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIndicatingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MethodLoggerObject.class);
    private static final String TSM_KEY = "org.springframework.transaction.support.TransactionSynchronizationManager";
    private static final Class[] emptyClasses = null;
    private static final Object[] emptyObjects = null;

    private TransactionIndicatingUtil() {
    }

    public static TransactionDescription getTransactionDescription() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        TransactionDescription desc = new TransactionDescription();
        if (contextClassLoader != null) {
            try {
                Class<?> tsmClass = contextClassLoader.loadClass(TSM_KEY);
                Boolean isActive = (Boolean)tsmClass.getMethod("isActualTransactionActive", emptyClasses).invoke(null, emptyObjects);
                if (!Boolean.TRUE.equals(isActive)) {
                    desc.setIsolation(0);
                    desc.setReadOnly(true);
                    desc.setName("no transaction");
                    return desc;
                }
                String transactionName = (String)tsmClass.getMethod("getCurrentTransactionName", emptyClasses).invoke(null, emptyObjects);
                Integer transactionIsolation = (Integer)tsmClass.getMethod("getCurrentTransactionIsolationLevel", emptyClasses).invoke(null, emptyObjects);
                Boolean isReadOnly = (Boolean)tsmClass.getMethod("isCurrentTransactionReadOnly", emptyClasses).invoke(null, emptyObjects);
                desc.setName(transactionName == null ? "unnamed transaction" : transactionName);
                desc.setActive(isActive);
                desc.setIsolation(transactionIsolation == null ? 0 : transactionIsolation);
                desc.setReadOnly(isReadOnly);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("!spring unavailable ", (Throwable)e);
                desc.setName("!spring unavailable " + e.getMessage());
            }
        } else {
            desc.setName("!ccl unavailable");
        }
        return desc;
    }
}

