/*
 * Decompiled with CFR 0.152.
 */
package cz.i24.util.resource.service;

import cz.i24.util.resource.dao.ResourcePropertyDao;
import cz.i24.util.resource.entity.ResourceProperty;
import cz.i24.util.resource.service.ResourcePropertyService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ResourcePropertyServiceImpl
implements ResourcePropertyService {
    private ResourcePropertyDao resourcePropertyDao;
    private String application;

    @Override
    @Transactional(readOnly=true)
    public Properties getMergedProperties(String application, List<Resource> locations, List<String> noupgrade, boolean noDB) {
        Properties properties = new Properties();
        if (CollectionUtils.isEmpty(locations)) {
            return properties;
        }
        for (Resource location : locations) {
            Properties locationProperties = new Properties();
            try {
                String filename = location.getFilename();
                if (CollectionUtils.isEmpty(noupgrade) || noupgrade.contains(filename)) {
                    // empty if block
                }
                InputStream is = location.getInputStream();
                if (filename != null && filename.endsWith(".xml")) {
                    locationProperties.loadFromXML(is);
                } else {
                    locationProperties.load(is);
                }
            }
            catch (IOException e) {
                throw new BeanInitializationException("Could not load properties " + location.getDescription(), (Throwable)e);
            }
            if (noDB) {
                CollectionUtils.mergePropertiesIntoMap((Properties)locationProperties, (Map)properties);
                continue;
            }
            List<ResourceProperty> existingProperties = this.resourcePropertyDao.loadAllValid(application, location.getFilename());
            CollectionUtils.mergePropertiesIntoMap((Properties)this.getProperties(existingProperties), (Map)properties);
        }
        return properties;
    }

    @Override
    public Properties getProperties(List<ResourceProperty> validProperties) {
        Properties properties = new Properties();
        for (ResourceProperty resourceProperty : validProperties) {
            properties.setProperty(resourceProperty.getName(), StringUtils.trimToEmpty((String)resourceProperty.getValue()));
        }
        return properties;
    }

    protected List<ResourceProperty> mergeProperties(List<ResourceProperty> existingProperties, Properties locationProperties, String application, String locationName) {
        ArrayList<ResourceProperty> changedProperties = new ArrayList<ResourceProperty>();
        for (ResourceProperty existingProperty : existingProperties) {
            if (locationProperties.getProperty(existingProperty.getName()) == null) {
                existingProperty.setValidTo(new Date());
                changedProperties.add(existingProperty);
            }
            locationProperties.remove(existingProperty.getName());
        }
        for (Object locationPropertyKey : locationProperties.keySet()) {
            ResourceProperty resourceProperty = new ResourceProperty();
            resourceProperty.setLocation(locationName);
            resourceProperty.setName((String)locationPropertyKey);
            resourceProperty.setApplication(application);
            resourceProperty.setValue(locationProperties.getProperty((String)locationPropertyKey));
            changedProperties.add(resourceProperty);
        }
        return changedProperties;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ResourceProperty> loadAllValid(String application, String location) {
        return this.resourcePropertyDao.loadAllValid(application, location);
    }

    @Override
    public boolean isDev() {
        return System.getProperty("devOnly") != null;
    }

    public void setResourcePropertyDao(ResourcePropertyDao resourcePropertyDao) {
        this.resourcePropertyDao = resourcePropertyDao;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    @Override
    public String getApplication() {
        return this.application;
    }
}

