/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import cz.jeme.advancium.CustomAdvancementRewards;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CustomAdvancementRewardsImpl
implements CustomAdvancementRewards {
    public static final CustomAdvancementRewardsImpl EMPTY = new CustomAdvancementRewardsImpl(new Builder());
    private final int experience;
    private final List<NamespacedKey> recipeKeys;
    private final List<NamespacedKey> lootKeys;

    private CustomAdvancementRewardsImpl(Builder builder) {
        this.experience = builder.experience;
        this.recipeKeys = Collections.unmodifiableList(builder.recipeKeys);
        this.lootKeys = Collections.unmodifiableList(builder.lootKeys);
    }

    @Override
    public int experience() {
        return this.experience;
    }

    @Override
    public @Unmodifiable List<NamespacedKey> recipeKeys() {
        return this.recipeKeys;
    }

    @Override
    public @Unmodifiable List<NamespacedKey> lootTableKeys() {
        return this.lootKeys;
    }

    static final class Builder
    implements CustomAdvancementRewards.Builder {
        private int experience = 0;
        private final List<NamespacedKey> recipeKeys = new ArrayList<NamespacedKey>();
        private final List<NamespacedKey> lootKeys = new ArrayList<NamespacedKey>();

        Builder() {
        }

        @Override
        public CustomAdvancementRewards.Builder experience(int experience) {
            this.experience = experience;
            return this;
        }

        @Override
        public CustomAdvancementRewards.Builder addRecipe(@NotNull NamespacedKey key) {
            this.recipeKeys.add(key);
            return this;
        }

        @Override
        public CustomAdvancementRewards.Builder addLootTable(NamespacedKey key) {
            this.lootKeys.add(key);
            return this;
        }

        @Override
        public CustomAdvancementRewards build() {
            return new CustomAdvancementRewardsImpl(this);
        }
    }
}

