/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EventManager
implements Listener {
    private final Plugin plugin;
    private static final Map<String, EventManager> PLUGIN_EVENT_MANAGERS = new HashMap<String, EventManager>();

    private EventManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public <T extends Event> void subscribe(Class<T> eventClass, @NotNull Consumer<T> handler) {
        this.subscribe(eventClass, EventPriority.NORMAL, handler);
    }

    public <T extends Event> void subscribe(Class<T> eventClass, EventPriority priority, @NotNull Consumer<T> handler) {
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, priority, ($, event) -> {
            if (!eventClass.isInstance(event)) {
                return;
            }
            handler.accept((Event)eventClass.cast(event));
        }, this.plugin);
    }

    public static EventManager forPlugin(Plugin plugin) {
        return PLUGIN_EVENT_MANAGERS.computeIfAbsent(plugin.getName(), $ -> new EventManager(plugin));
    }
}

