/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import cz.jeme.advancium.AdvancementLoader;
import cz.jeme.advancium.CustomAdvancement;
import cz.jeme.advancium.CustomAdvancementDisplay;
import cz.jeme.advancium.CustomAdvancementRewards;
import cz.jeme.advancium.CustomAdvancementTab;
import cz.jeme.advancium.EventManager;
import cz.jeme.advancium.EventRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class CustomAdvancementImpl
implements CustomAdvancement {
    private final NamespacedKey key;
    private final CustomAdvancementDisplay display;
    private final CustomAdvancementRewards rewards;
    private final Set<String> criteria;
    private final Set<Set<String>> requirements;
    private final @Nullable NamespacedKey parentKey;
    private final @Nullable CustomAdvancement parent;
    private final @Nullable CustomAdvancementTab tab;
    private final Plugin plugin;

    private CustomAdvancementImpl(Builder builder, NamespacedKey parentKey, Plugin plugin) {
        this.parent = null;
        this.tab = null;
        this.parentKey = parentKey;
        this.plugin = plugin;
        this.key = builder.key;
        this.display = builder.display;
        this.rewards = builder.rewards;
        this.criteria = Collections.unmodifiableSet(builder.criteria);
        this.requirements = builder.requirements.stream().map(Collections::unmodifiableSet).collect(Collectors.toSet());
        this.register(builder);
    }

    private CustomAdvancementImpl(Builder builder, CustomAdvancement parent) {
        this.parent = parent;
        this.tab = parent.tab();
        this.parentKey = parent.key();
        this.plugin = parent.plugin();
        this.key = builder.key;
        this.display = builder.display;
        this.rewards = builder.rewards;
        this.criteria = Collections.unmodifiableSet(builder.criteria);
        this.requirements = builder.requirements.stream().map(Collections::unmodifiableSet).collect(Collectors.toSet());
        this.register(builder);
    }

    private CustomAdvancementImpl(Builder builder, CustomAdvancementTab tab) {
        this.parent = null;
        this.tab = tab;
        this.parentKey = null;
        this.plugin = tab.plugin();
        this.key = builder.key;
        this.display = builder.display;
        this.rewards = builder.rewards;
        this.criteria = Collections.unmodifiableSet(builder.criteria);
        this.requirements = builder.requirements.stream().map(Collections::unmodifiableSet).collect(Collectors.toSet());
        this.register(builder);
    }

    private void register(Builder builder) {
        builder.eventRegistrations.forEach(reg -> EventManager.forPlugin(this.plugin).subscribe(reg.eventClass(), reg.eventPriority(), event -> {
            BiConsumer<Event, CustomAdvancement> handler = reg.handler();
            handler.accept((Event)event, this);
        }));
        AdvancementLoader.INSTANCE.load(this);
    }

    @Override
    public CustomAdvancementDisplay display() {
        return this.display;
    }

    @Override
    public CustomAdvancementRewards rewards() {
        return this.rewards;
    }

    @Override
    public @Unmodifiable Set<String> criteria() {
        return this.criteria;
    }

    @Override
    public @Unmodifiable Set<Set<String>> requirements() {
        return this.requirements;
    }

    @Override
    public AdvancementProgress progress(Player player) {
        return player.getAdvancementProgress(this.asBukkit());
    }

    @Override
    public CustomAdvancementTab tab() {
        if (this.tab == null) {
            throw new UnsupportedOperationException("Advancement is bound to a bukkit advancement and therefore does not belong to a custom tab.");
        }
        return this.tab;
    }

    @Override
    public CustomAdvancement parent() {
        if (this.parent == null) {
            throw new UnsupportedOperationException("");
        }
        return this.parent;
    }

    @Override
    public NamespacedKey parentKey() {
        if (this.parentKey == null) {
            throw new UnsupportedOperationException("");
        }
        return this.parentKey;
    }

    @Override
    public Advancement asBukkit() {
        return Objects.requireNonNull(Bukkit.getAdvancement((NamespacedKey)this.key), "This advancement is not loaded to the server");
    }

    @Override
    public boolean isRoot() {
        return this.parentKey == null;
    }

    @Override
    public boolean hasCustomParent() {
        return this.parent != null;
    }

    @Override
    public boolean hasCustomTab() {
        return this.tab != null;
    }

    @Override
    public Plugin plugin() {
        return this.plugin;
    }

    @Override
    public NamespacedKey key() {
        return this.key;
    }

    static final class Builder
    implements CustomAdvancement.Builder {
        private final NamespacedKey key;
        private final List<EventRegistration<? extends Event>> eventRegistrations = new ArrayList<EventRegistration<? extends Event>>();
        private CustomAdvancementDisplay display = CustomAdvancementDisplay.empty();
        private CustomAdvancementRewards rewards = CustomAdvancementRewards.empty();
        private Set<String> criteria = Set.of("dummy");
        private Set<Set<String>> requirements = Set.of(Set.of("dummy"));

        public Builder(NamespacedKey key) {
            this.key = key;
        }

        @Override
        public CustomAdvancement.Builder display(CustomAdvancementDisplay display) {
            this.display = display;
            return this;
        }

        @Override
        public CustomAdvancement.Builder rewards(CustomAdvancementRewards rewards) {
            this.rewards = rewards;
            return this;
        }

        @Override
        public CustomAdvancement.Builder criteria(Set<String> criteria) {
            this.criteria = criteria;
            this.requirements = criteria.stream().map(Set::of).collect(Collectors.toSet());
            return this;
        }

        @Override
        public CustomAdvancement.Builder requirements(Set<Set<String>> requirements) {
            this.requirements = requirements;
            return this;
        }

        @Override
        public <T extends Event> CustomAdvancement.Builder on(Class<T> eventClass, EventPriority priority, BiConsumer<T, CustomAdvancement> handler) {
            this.eventRegistrations.add(new EventRegistration<T>(eventClass, priority, handler));
            return this;
        }

        @Override
        public CustomAdvancement buildAndBindTo(CustomAdvancement parent) {
            return new CustomAdvancementImpl(this, parent);
        }

        @Override
        public CustomAdvancement buildAndBindToBukkit(NamespacedKey key, Plugin plugin) {
            return new CustomAdvancementImpl(this, key, plugin);
        }

        @ApiStatus.Internal
        CustomAdvancement buildRoot(CustomAdvancementTab tab) {
            return new CustomAdvancementImpl(this, tab);
        }
    }
}

