/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import cz.jeme.advancium.CustomAdvancementDisplayImpl;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface CustomAdvancementDisplay
permits CustomAdvancementDisplayImpl {
    public static Builder display() {
        return new CustomAdvancementDisplayImpl.Builder();
    }

    public static CustomAdvancementDisplay empty() {
        return CustomAdvancementDisplayImpl.EMPTY;
    }

    public ItemStack icon();

    public Component title();

    public Component description();

    public Frame frame();

    public boolean showToast();

    public boolean announceToChat();

    public boolean hidden();

    public static enum Frame {
        TASK("task"),
        GOAL("goal"),
        CHALLENGE("challenge");

        private final String id;

        private Frame(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }

    public static sealed interface Builder
    permits CustomAdvancementDisplayImpl.Builder {
        public Builder icon(ItemStack var1);

        default public Builder icon(Material icon) {
            return this.icon(ItemStack.of((Material)icon));
        }

        default public Builder icon(ItemStack item, Consumer<ItemStack> consumer) {
            consumer.accept(item);
            return this.icon(item);
        }

        public Builder title(Component var1);

        public Builder description(Component var1);

        public Builder frame(Frame var1);

        public Builder showToast(boolean var1);

        public Builder announceToChat(boolean var1);

        public Builder hidden(boolean var1);

        public CustomAdvancementDisplay build();
    }
}

