/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import cz.jeme.advancium.CustomAdvancementDisplay;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CustomAdvancementDisplayImpl
implements CustomAdvancementDisplay {
    public static final CustomAdvancementDisplayImpl EMPTY = new CustomAdvancementDisplayImpl(new Builder());
    private final ItemStack icon;
    private final Component title;
    private final Component description;
    private final CustomAdvancementDisplay.Frame frame;
    private final boolean showToast;
    private final boolean announceToChat;
    private final boolean hidden;

    private CustomAdvancementDisplayImpl(Builder builder) {
        this.icon = builder.icon.clone();
        this.title = builder.title;
        this.description = builder.description;
        this.frame = builder.frame;
        this.showToast = builder.showToast;
        this.announceToChat = builder.announceToChat;
        this.hidden = builder.hidden;
    }

    @Override
    public ItemStack icon() {
        return this.icon.clone();
    }

    @Override
    public Component title() {
        return this.title;
    }

    @Override
    public Component description() {
        return this.description;
    }

    @Override
    public CustomAdvancementDisplay.Frame frame() {
        return this.frame;
    }

    @Override
    public boolean showToast() {
        return this.showToast;
    }

    @Override
    public boolean announceToChat() {
        return this.announceToChat;
    }

    @Override
    public boolean hidden() {
        return this.hidden;
    }

    static final class Builder
    implements CustomAdvancementDisplay.Builder {
        private static final ItemStack DEFAULT_ICON = ItemStack.of((Material)Material.GRASS_BLOCK);
        private ItemStack icon = DEFAULT_ICON;
        private Component title = Component.empty();
        private Component description = Component.empty();
        private CustomAdvancementDisplay.Frame frame = CustomAdvancementDisplay.Frame.TASK;
        private boolean showToast = true;
        private boolean announceToChat = true;
        private boolean hidden = false;

        Builder() {
        }

        @Override
        public CustomAdvancementDisplay.Builder icon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder title(Component title) {
            this.title = title;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder description(Component description) {
            this.description = description;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder frame(CustomAdvancementDisplay.Frame frame) {
            this.frame = frame;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder showToast(boolean showToast) {
            this.showToast = showToast;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder announceToChat(boolean announceToChat) {
            this.announceToChat = announceToChat;
            return this;
        }

        @Override
        public CustomAdvancementDisplay.Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Override
        public CustomAdvancementDisplay build() {
            return new CustomAdvancementDisplayImpl(this);
        }
    }
}

