/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EventManager
implements Listener {
    private final Plugin plugin;
    private final Map<Class<? extends Event>, Map<EventPriority, List<Consumer<? extends Event>>>> eventMap = new HashMap<Class<? extends Event>, Map<EventPriority, List<Consumer<? extends Event>>>>();
    private static final Map<String, EventManager> PLUGIN_EVENT_MANAGERS = new HashMap<String, EventManager>();

    private EventManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public <T extends Event> void subscribe(Class<T> eventClass, Consumer<T> handler) {
        this.subscribe(eventClass, EventPriority.NORMAL, handler);
    }

    public <T extends Event> void subscribe(Class<T> eventClass, EventPriority priority, Consumer<T> handler) {
        Map priorityMap = this.eventMap.computeIfAbsent(eventClass, $ -> new HashMap());
        priorityMap.computeIfAbsent(priority, $ -> {
            ArrayList list = new ArrayList();
            Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, priority, ($$, event) -> {
                if (!eventClass.isInstance(event)) {
                    return;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Consumer h;
                    Consumer cH = h = (Consumer)iterator.next();
                    cH.accept(event);
                }
            }, this.plugin);
            return list;
        }).add(handler);
    }

    public static EventManager forPlugin(Plugin plugin) {
        return PLUGIN_EVENT_MANAGERS.computeIfAbsent(plugin.getName(), $ -> new EventManager(plugin));
    }
}

