/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import com.google.gson.Gson;
import cz.jeme.advancium.CustomAdvancement;
import cz.jeme.advancium.CustomAdvancementDisplay;
import cz.jeme.advancium.CustomAdvancementRewards;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;

enum AdvancementLoader {
    INSTANCE;

    private final UnsafeValues unsafe = Bukkit.getUnsafe();
    private final JSONComponentSerializer serializer = JSONComponentSerializer.json();
    private final Gson gson = new Gson();

    public Advancement load(CustomAdvancement advancement) {
        boolean root = advancement.isRoot();
        CustomAdvancementDisplay display = advancement.display();
        CustomAdvancementRewards rewards = advancement.rewards();
        try {
            String criteria = this.gson.toJson(advancement.criteria().stream().collect(Collectors.toMap(key -> key, key -> Map.of("trigger", "minecraft:impossible"))));
            String requirements = this.gson.toJson(advancement.requirements());
            String recipes = this.gson.toJson(rewards.recipeKeys().stream().map(NamespacedKey::asString).toList());
            String loot = this.gson.toJson(rewards.lootTableKeys().stream().map(NamespacedKey::asString).toList());
            String json = "{\n    \"parent\": %s,\n    \"display\": {\n        \"icon\": %s,\n        \"title\": %s,\n        \"description\": %s,\n        \"frame\": \"%s\",\n        \"background\": \"%s\",\n        \"show_toast\": %b,\n        \"announce_to_chat\": %b,\n        \"hidden\": %b\n    },\n    \"criteria\": %s,\n    \"requirements\": %s,\n    \"rewards\": {\n        \"experience\": %d,\n        \"recipes\": %s,\n        \"loot\": %s\n    }\n}\n".formatted(root ? null : "\"" + advancement.parentKey().asString() + "\"", this.unsafe.serializeItemAsJson(display.icon()).toString(), this.serializer.serialize(display.title()), this.serializer.serialize(display.description()), display.frame().id(), root ? advancement.tab().background() : null, display.showToast(), display.announceToChat(), display.hidden(), criteria, requirements, rewards.experience(), recipes, loot);
            return this.unsafe.loadAdvancement(advancement.key(), json);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load advancement: \"" + String.valueOf(advancement.key()) + "\"", e);
        }
    }
}

