/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import cz.jeme.advancium.CustomAdvancementRewardsImpl;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.key.KeyPattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface CustomAdvancementRewards {
    public static Builder rewards() {
        return new CustomAdvancementRewardsImpl.Builder();
    }

    public static CustomAdvancementRewards empty() {
        return CustomAdvancementRewardsImpl.EMPTY;
    }

    public int experience();

    public @Unmodifiable List<NamespacedKey> recipeKeys();

    default public @Unmodifiable List<Recipe> recipes() {
        return this.recipeKeys().stream().map(Bukkit::getRecipe).map(Objects::requireNonNull).toList();
    }

    public @Unmodifiable List<NamespacedKey> lootTableKeys();

    default public @Unmodifiable List<LootTable> lootTables() {
        return this.lootTableKeys().stream().map(Bukkit::getLootTable).map(Objects::requireNonNull).toList();
    }

    public @Unmodifiable List<ItemStack> loot();

    public static interface Builder {
        public Builder experience(int var1);

        public Builder addRecipe(NamespacedKey var1);

        default public <R extends Recipe & Keyed> Builder addRecipe(@NotNull R recipe) {
            return this.addRecipe(((Keyed)recipe).getKey());
        }

        default public Builder addRecipe(@KeyPattern String key) {
            return this.addRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)key), "Invalid key: \"" + key + "\""));
        }

        public Builder addLootTable(NamespacedKey var1);

        default public Builder addLootTable(LootTable lootTable) {
            return this.addLootTable(lootTable.getKey());
        }

        default public Builder addLootTable(@KeyPattern String key) {
            return this.addLootTable(Objects.requireNonNull(NamespacedKey.fromString((String)key), "Invalid key: \"" + key + "\""));
        }

        public Builder addLoot(ItemStack var1);

        default public Builder addLoot(Material material) {
            return this.addLoot(ItemStack.of((Material)material));
        }

        default public Builder addLoot(ItemStack item, Consumer<ItemStack> consumer) {
            consumer.accept(item);
            return this.addLoot(item);
        }

        public CustomAdvancementRewards build();
    }
}

