/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.advancium;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import cz.jeme.advancium.AdvancementLoader;
import cz.jeme.advancium.BaseCustomAdvancement;
import cz.jeme.advancium.BukkitCustomAdvancement;
import cz.jeme.advancium.CustomAdvancement;
import cz.jeme.advancium.CustomAdvancementDisplay;
import cz.jeme.advancium.CustomAdvancementRewards;
import cz.jeme.advancium.CustomAdvancementRewardsImpl;
import cz.jeme.advancium.CustomAdvancementTab;
import cz.jeme.advancium.EventManager;
import cz.jeme.advancium.EventRegistration;
import cz.jeme.advancium.RootCustomAdvancement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

abstract sealed class AbstractCustomAdvancement
implements CustomAdvancement
permits BaseCustomAdvancement, RootCustomAdvancement, BukkitCustomAdvancement {
    protected final Plugin plugin;
    protected final NamespacedKey key;
    protected final CustomAdvancementDisplay display;
    protected final CustomAdvancementRewards rewards;
    protected final Set<String> criteria;
    protected final Set<Set<String>> requirements;
    @Nullable
    private Advancement bukkit;

    protected AbstractCustomAdvancement(Builder builder, Plugin plugin) {
        this.plugin = plugin;
        this.key = builder.key;
        this.display = builder.display;
        this.rewards = builder.rewards;
        this.criteria = builder.criteria;
        this.requirements = builder.requirements.stream().map(Collections::unmodifiableSet).collect(Collectors.toSet());
    }

    @ApiStatus.Internal
    void register(Builder builder) {
        builder.eventRegistrations.forEach(reg -> EventManager.forPlugin(this.plugin).subscribe(reg.eventClass(), reg.eventPriority(), event -> {
            BiConsumer<Event, CustomAdvancement> handler = reg.handler();
            handler.accept((Event)event, this);
        }));
        this.bukkit = AdvancementLoader.INSTANCE.load(this);
    }

    @Override
    public Advancement asBukkit() {
        if (this.bukkit == null) {
            this.bukkit = Objects.requireNonNull(Bukkit.getAdvancement((NamespacedKey)this.key), "Could not obtain Bukkit representation of this custom advancement, this advancement is not loaded to the server");
        }
        return this.bukkit;
    }

    @Override
    public @Unmodifiable Set<String> criteria() {
        return this.criteria;
    }

    @Override
    public CustomAdvancementDisplay display() {
        return this.display;
    }

    @Override
    public Plugin plugin() {
        return this.plugin;
    }

    @Override
    public AdvancementProgress progress(Player player) {
        return player.getAdvancementProgress(this.asBukkit());
    }

    @Override
    public @Unmodifiable Set<Set<String>> requirements() {
        return this.requirements;
    }

    @Override
    public CustomAdvancementRewards rewards() {
        return this.rewards;
    }

    @Override
    public NamespacedKey key() {
        return this.key;
    }

    static final class Builder
    implements CustomAdvancement.Builder {
        private final NamespacedKey key;
        private CustomAdvancementDisplay display = CustomAdvancementDisplay.empty();
        private CustomAdvancementRewards rewards = CustomAdvancementRewards.empty();
        private @Unmodifiable Set<String> criteria = Set.of("dummy");
        private Set<Set<String>> requirements = Set.of(this.criteria);
        private final List<EventRegistration<? extends Event>> eventRegistrations = new ArrayList<EventRegistration<? extends Event>>();
        private final List<BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement>> criterionGrantedHandlers = new ArrayList<BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement>>();
        private final List<BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement>> advancementCompletedHandlers = new ArrayList<BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement>>();

        public Builder(NamespacedKey key) {
            this.key = key;
        }

        @Override
        public CustomAdvancement.Builder display(CustomAdvancementDisplay display) {
            this.display = display;
            return this;
        }

        @Override
        public CustomAdvancement.Builder rewards(CustomAdvancementRewards rewards) {
            this.rewards = rewards;
            return this;
        }

        @Override
        public CustomAdvancement.Builder requirements(Set<Set<String>> requirements) {
            this.criteria = requirements.stream().flatMap(Collection::stream).peek(criterion -> {
                if (criterion.isBlank()) {
                    throw new IllegalArgumentException("Empty criterion name");
                }
            }).collect(Collectors.toSet());
            if (this.criteria.isEmpty()) {
                throw new IllegalArgumentException("No criteria provided");
            }
            this.requirements = requirements;
            return this;
        }

        @Override
        public <T extends Event> CustomAdvancement.Builder on(Class<T> eventClass, EventPriority priority, BiConsumer<T, CustomAdvancement> handler) {
            this.eventRegistrations.add(new EventRegistration<T>(eventClass, priority, handler));
            return this;
        }

        @Override
        public CustomAdvancement.Builder onCriterionGranted(BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement> handler) {
            this.criterionGrantedHandlers.add(handler);
            return this;
        }

        @Override
        public CustomAdvancement.Builder onAdvancementCompleted(BiConsumer<PlayerAdvancementCriterionGrantEvent, CustomAdvancement> handler) {
            this.advancementCompletedHandlers.add(handler);
            return this;
        }

        private void registerCriterionEvents() {
            List<ItemStack> unsafeLootRewards = ((CustomAdvancementRewardsImpl)this.rewards).loot;
            if (this.criterionGrantedHandlers.isEmpty() && this.advancementCompletedHandlers.isEmpty() && unsafeLootRewards.isEmpty()) {
                return;
            }
            this.on(PlayerAdvancementCriterionGrantEvent.class, EventPriority.NORMAL, (event, advancement) -> {
                if (!event.getAdvancement().getKey().equals((Object)this.key)) {
                    return;
                }
                this.criterionGrantedHandlers.forEach(handler -> handler.accept(event, advancement));
                if (!event.getAdvancementProgress().isDone()) {
                    return;
                }
                this.advancementCompletedHandlers.forEach(handler -> handler.accept(event, advancement));
                if (event.isCancelled()) {
                    return;
                }
                Player player = event.getPlayer();
                Collection overflow = player.getInventory().addItem(unsafeLootRewards.toArray(new ItemStack[0])).values();
                for (ItemStack item : overflow) {
                    player.getWorld().dropItem(player.getLocation(), item);
                }
            });
        }

        @NotNull
        private <T extends AbstractCustomAdvancement> T buildAndLoad(@NotNull T advancement) {
            this.registerCriterionEvents();
            advancement.register(this);
            return advancement;
        }

        @Override
        public CustomAdvancement buildAndBindTo(CustomAdvancement parent) {
            return this.buildAndLoad(new BaseCustomAdvancement(this, parent));
        }

        @Override
        public CustomAdvancement buildAndBindToBukkit(NamespacedKey key, Plugin plugin) {
            return this.buildAndLoad(new BukkitCustomAdvancement(this, key, plugin));
        }

        @ApiStatus.Internal
        CustomAdvancement buildRoot(CustomAdvancementTab tab) {
            return this.buildAndLoad(new RootCustomAdvancement(this, tab));
        }
    }
}

