package cz.jeme.bestium.api.entity;

import cz.jeme.bestium.api.inject.Injectable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.NullMarked;

/**
 * Extend this class to implement your own golem with custom behavior or properties.
 * <p>
 * Examples of vanilla {@link AbstractGolem} subclasses: {@link IronGolem}, {@link SnowGolem}
 */
@NullMarked
public abstract class CustomAbstractGolem extends AbstractGolem implements Injectable {
    protected CustomAbstractGolem(final EntityType<? extends CustomAbstractGolem> entityType,
                                  final Level level) {
        super(entityType, level);
        bestium_init();
    }

    @Override
    public final EntityType<?> getType() {
        return bestium_backingType();
    }

    @Override
    public void addAdditionalSaveData(final ValueOutput output) {
        super.addAdditionalSaveData(output);
        bestium_addAdditionalSaveData(output);
    }
}
