/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api;

import cz.jeme.bestium.api.PluginSupport;
import cz.jeme.bestium.api.inject.EntityInjector;
import cz.jeme.bestium.api.inject.Injectable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Bestium {
    public static JavaPlugin getPlugin() {
        return (JavaPlugin)InstanceHolder.getObject("cz.jeme.bestium.BestiumPlugin");
    }

    public static Bestium getBestium() {
        return (Bestium)Bestium.getPlugin();
    }

    public static EntityInjector getInjector() {
        return (EntityInjector)InstanceHolder.getObject("cz.jeme.bestium.EntityInjectorImpl");
    }

    public static PluginSupport getPluginSupport() {
        return (PluginSupport)InstanceHolder.getObject("cz.jeme.bestium.PluginSupportImpl");
    }

    public static <T extends net.minecraft.world.entity.Entity> @Nullable T spawn(Location location, Class<T> entityClass, EntitySpawnReason entitySpawnReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason, Consumer<T> consumer) {
        EntityType type = Bestium.getInjector().getTypes().get(entityClass);
        if (type == null) {
            throw new IllegalArgumentException("Entity '" + String.valueOf(entityClass) + "' is not an injected entity!");
        }
        net.minecraft.world.entity.Entity entity = type.spawn(((CraftWorld)location.getWorld()).getHandle(), e -> {
            e.snapTo(location.x(), location.y(), location.z(), e.getYRot(), e.getXRot());
            consumer.accept(e);
        }, CraftLocation.toBlockPosition((Location)location), entitySpawnReason, false, false, creatureSpawnReason);
        return (T)entity;
    }

    public static <T extends net.minecraft.world.entity.Entity> @Nullable T spawn(Location location, Class<T> entityClass, EntitySpawnReason entitySpawnReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)Bestium.spawn(location, entityClass, entitySpawnReason, creatureSpawnReason, e -> {});
    }

    public static @Nullable Key getInjectedEntityKey(Entity entity) {
        String keyStr = (String)entity.getPersistentDataContainer().get(Injectable.BESTIUM_ID_KEY, PersistentDataType.STRING);
        return keyStr == null ? null : Key.key((String)keyStr);
    }

    public static Key requireInjectedEntityKey(Entity entity) {
        Key key = Bestium.getInjectedEntityKey(entity);
        if (key == null) {
            throw new IllegalArgumentException("Provided entity is not an injected entity!");
        }
        return key;
    }

    public static boolean isInjectedEntity(Entity entity) {
        return entity.getPersistentDataContainer().has(Injectable.BESTIUM_ID_KEY, PersistentDataType.STRING);
    }

    @ApiStatus.Internal
    public NamespacedKey createKey(@KeyPattern.Value String var1);

    @ApiStatus.Internal
    public static final class InstanceHolder {
        private static final Map<String, Object> INSTANCES = new HashMap<String, Object>();

        private InstanceHolder() {
            throw new AssertionError();
        }

        private static Object getObject(String className) {
            Object inst = INSTANCES.get(className);
            if (inst == null) {
                throw new IllegalStateException("'" + className + "' not initialized yet");
            }
            return inst;
        }
    }
}

