/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject;

import cz.jeme.bestium.api.inject.ConvertFunction;
import cz.jeme.bestium.api.inject.EntityInjection;
import cz.jeme.bestium.api.util.ModelUtils;
import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class EntityInjectionImpl<T extends net.minecraft.world.entity.Entity, B extends Entity>
implements EntityInjection<T, B> {
    private final Key key;
    private final Class<T> entityClass;
    private final EntityType.EntityFactory<T> entityFactory;
    private final ConvertFunction<T, B> convertFunction;
    private final EntityType<?> backingType;
    private final MobCategory category;
    private final Consumer<EntityType.Builder<T>> typeBuilder;
    private final @Nullable String modelName;
    private final @Nullable AttributeSupplier attributes;
    private final @Nullable URL modelUrl;

    private EntityInjectionImpl(BuilderImpl<T, B> builder) {
        this.key = builder.key;
        this.entityClass = builder.entityClass;
        this.entityFactory = builder.entityFactory;
        this.convertFunction = builder.convertFunction;
        this.backingType = builder.backingType;
        this.category = builder.category;
        this.typeBuilder = builder.typeBuilder;
        this.attributes = builder.attributes;
        this.modelUrl = builder.modelUrl;
        this.modelName = this.modelUrl == null ? null : ModelUtils.keyToModelName(this.key);
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityType.EntityFactory<T> getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public ConvertFunction<T, B> getConvertFunction() {
        return this.convertFunction;
    }

    @Override
    public EntityType<?> getBackingType() {
        return this.backingType;
    }

    @Override
    public MobCategory getMobCategory() {
        return this.category;
    }

    @Override
    public Consumer<EntityType.Builder<T>> getTypeCustomizer() {
        return this.typeBuilder;
    }

    @Override
    public @Nullable AttributeSupplier getDefaultAttributes() {
        return this.attributes;
    }

    @Override
    public @Nullable URL getModelUrl() {
        return this.modelUrl;
    }

    @Override
    public @Nullable String getModelName() {
        return this.modelName;
    }

    public String toString() {
        return "EntityInjectionImpl{key=" + String.valueOf(this.key) + ", entityClass=" + this.entityClass.getName() + ", backingType=" + String.valueOf(this.backingType) + ", category=" + String.valueOf(this.category) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EntityInjectionImpl)) {
            return false;
        }
        EntityInjectionImpl that = (EntityInjectionImpl)o;
        return this.key.equals((Object)that.key) && this.entityClass.equals(that.entityClass) && this.entityFactory.equals(that.entityFactory) && this.convertFunction.equals(that.convertFunction) && this.backingType.equals(that.backingType) && this.category == that.category && this.typeBuilder.equals(that.typeBuilder) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.entityClass.hashCode();
        result = 31 * result + this.entityFactory.hashCode();
        result = 31 * result + this.convertFunction.hashCode();
        result = 31 * result + this.backingType.hashCode();
        result = 31 * result + this.category.hashCode();
        result = 31 * result + this.typeBuilder.hashCode();
        result = 31 * result + Objects.hashCode(this.attributes);
        return result;
    }

    static final class BuilderImpl<T extends net.minecraft.world.entity.Entity, B extends Entity>
    implements EntityInjection.Builder<T, B> {
        private final Key key;
        private final Class<T> entityClass;
        private final EntityType.EntityFactory<T> entityFactory;
        private final ConvertFunction<T, B> convertFunction;
        private final boolean isLivingEntity;
        private EntityType<?> backingType = EntityType.SILVERFISH;
        private MobCategory category = MobCategory.MISC;
        private Consumer<EntityType.Builder<T>> typeBuilder = b -> {};
        private @Nullable AttributeSupplier attributes;
        private @Nullable URL modelUrl;

        public BuilderImpl(Key key, Class<T> entityClass, EntityType.EntityFactory<T> entityFactory, ConvertFunction<T, B> convertFunction) {
            this.key = key;
            this.entityClass = entityClass;
            this.entityFactory = entityFactory;
            this.convertFunction = convertFunction;
            this.isLivingEntity = LivingEntity.class.isAssignableFrom(entityClass);
            this.attributes = this.isLivingEntity ? LivingEntity.createLivingAttributes().build() : null;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Class<T> getEntityClass() {
            return this.entityClass;
        }

        @Override
        public EntityType.EntityFactory<T> getEntityFactory() {
            return this.entityFactory;
        }

        @Override
        public ConvertFunction<T, B> getConvertFunction() {
            return this.convertFunction;
        }

        @Override
        public EntityInjection.Builder<T, B> setBackingType(EntityType<?> backingType) {
            this.backingType = backingType;
            return this;
        }

        @Override
        public EntityType<?> getBackingType() {
            return this.backingType;
        }

        @Override
        public EntityInjection.Builder<T, B> setMobCategory(MobCategory category) {
            this.category = category;
            return this;
        }

        @Override
        public MobCategory getMobCategory() {
            return this.category;
        }

        @Override
        public EntityInjection.Builder<T, B> setTypeCustomizer(Consumer<EntityType.Builder<T>> typeBuilder) {
            this.typeBuilder = typeBuilder;
            return this;
        }

        @Override
        public Consumer<EntityType.Builder<T>> getTypeCustomizer() {
            return this.typeBuilder;
        }

        @Override
        public EntityInjection.Builder<T, B> setDefaultAttributes(AttributeSupplier attributes) {
            if (!this.isLivingEntity) {
                throw new UnsupportedOperationException("'" + this.entityClass.getName() + "' does not extend '" + LivingEntity.class.getName() + "'. Only living entities can have attributes.");
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public @Nullable AttributeSupplier getDefaultAttributes() {
            return this.attributes;
        }

        @Override
        public EntityInjection.Builder<T, B> setModel(URL url) {
            this.modelUrl = url;
            return this;
        }

        @Override
        public @Nullable URL getModelUrl() {
            return this.modelUrl;
        }

        @NotNull
        public EntityInjection<T, B> build() {
            return new EntityInjectionImpl(this);
        }
    }
}

