/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject;

import cz.jeme.bestium.api.Bestium;
import cz.jeme.bestium.api.util.ModelUtils;
import java.util.Objects;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import net.kyori.adventure.key.Key;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface Injectable {
    @ApiStatus.Internal
    public static final NamespacedKey BESTIUM_ID_KEY = Bestium.getBestium().createKey("bestium_id");

    @ApiStatus.NonExtendable
    @NotNull
    default public <T extends Entity> T asBestiumEntity() {
        Injectable injectable = this;
        if (!(injectable instanceof Entity)) {
            throw new IllegalStateException("Classes implementing '" + Injectable.class.getName() + "' must extend '" + Entity.class.getName() + "'");
        }
        Entity entity = (Entity)injectable;
        return (T)entity;
    }

    @ApiStatus.NonExtendable
    default public Key getBestiumKey() {
        return Objects.requireNonNull(Bestium.getInjector().getInjections().get(this.asBestiumEntity().getClass()).getKey());
    }

    @ApiStatus.NonExtendable
    default public EntityType<?> getBestiumBackingType() {
        return Bestium.getInjector().getInjections().get(this.getClass()).getBackingType();
    }

    @ApiStatus.NonExtendable
    default public EntityType<?> getBestiumRealType() {
        return Bestium.getInjector().getTypes().get(this.getClass());
    }

    @ApiStatus.NonExtendable
    default public void addBestiumAdditionalSaveData(ValueOutput output) {
        output.putString("id", this.getBestiumKey().asString());
    }

    @ApiStatus.NonExtendable
    default public void initBestium() {
        Object entity = this.asBestiumEntity();
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Key key = this.getBestiumKey();
        bukkitEntity.getPersistentDataContainer().set(BESTIUM_ID_KEY, PersistentDataType.STRING, (Object)key.asString());
        if (Bestium.getPluginSupport().betterModel()) {
            bukkitEntity.getPersistentDataContainer().set(EntityTrackerRegistry.TRACKING_ID, PersistentDataType.STRING, (Object)ModelUtils.keyToModelName(key));
        }
    }
}

