/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject;

import cz.jeme.bestium.api.Bestium;
import cz.jeme.bestium.api.inject.ConvertFunction;
import cz.jeme.bestium.api.inject.EntityInjection;
import cz.jeme.bestium.api.inject.biome.SpawnRule;
import cz.jeme.bestium.api.inject.variant.BoundEntityVariant;
import cz.jeme.bestium.api.inject.variant.EntityVariant;
import cz.jeme.bestium.api.inject.variant.UnboundEntityVariant;
import cz.jeme.bestium.api.inject.variant.VariantRule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

final class EntityInjectionImpl<T extends net.minecraft.world.entity.Entity, B extends Entity>
implements EntityInjection<T, B> {
    private final Key key;
    private final Class<T> entityClass;
    private final EntityType.EntityFactory<T> entityFactory;
    private final ConvertFunction<T, B> convertFunction;
    private final EntityType<?> backingType;
    private final MobCategory category;
    private final Consumer<EntityType.Builder<T>> typeBuilder;
    private final @Nullable AttributeSupplier attributes;
    private final Map<String, BoundEntityVariant> variants;
    private final Map<Locale, Component> displayNames;
    private final VariantRule variantRule;
    private final SpawnRule spawnRule;
    private @Nullable EntityType<T> lazyRealType;

    private EntityInjectionImpl(BuilderImpl<T, B> builder) {
        this.key = builder.key;
        this.entityClass = builder.entityClass;
        this.entityFactory = builder.entityFactory;
        this.convertFunction = builder.convertFunction;
        this.backingType = builder.backingType;
        this.category = builder.category;
        this.typeBuilder = builder.typeBuilder;
        this.attributes = builder.attributes;
        this.variants = Collections.unmodifiableMap(builder.variants.stream().map(variant -> variant.bind(this)).collect(Collectors.toMap(EntityVariant::getId, Function.identity(), (variant1, variant2) -> {
            throw new AssertionError((Object)"Duplicate variant keys encountered in a set. This indicates an issue with the equals function of AbstractEntityVariant.");
        }, LinkedHashMap::new)));
        this.displayNames = Collections.unmodifiableMap(builder.displayNames);
        this.variantRule = builder.variantRule;
        this.spawnRule = builder.spawnRule;
        if (LivingEntity.class.isAssignableFrom(this.entityClass) && this.attributes == null) {
            throw new IllegalArgumentException("Living entities must have attributes");
        }
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityType.EntityFactory<T> getEntityFactory() {
        return this.entityFactory;
    }

    @Override
    public ConvertFunction<T, B> getConvertFunction() {
        return this.convertFunction;
    }

    @Override
    public EntityType<?> getBackingType() {
        return this.backingType;
    }

    @Override
    public MobCategory getMobCategory() {
        return this.category;
    }

    @Override
    public Consumer<EntityType.Builder<T>> getTypeCustomizer() {
        return this.typeBuilder;
    }

    @Override
    public @Nullable AttributeSupplier getDefaultAttributes() {
        return this.attributes;
    }

    @Override
    public @Unmodifiable Map<String, BoundEntityVariant> getVariants() {
        return this.variants;
    }

    @Override
    public @Unmodifiable Map<Locale, Component> getDisplayNames() {
        return this.displayNames;
    }

    @Override
    public VariantRule getVariantRule() {
        return this.variantRule;
    }

    @Override
    public SpawnRule getSpawnRule() {
        return this.spawnRule;
    }

    @Override
    public EntityType<T> getRealType() {
        if (this.lazyRealType == null) {
            EntityType<?> type = Bestium.getInjector().getTypes().get(this.entityClass);
            if (type == null) {
                throw new IllegalStateException("Cannot get real Bestium entity type, injection hasn't finished yet");
            }
            this.lazyRealType = type;
        }
        return this.lazyRealType;
    }

    public String toString() {
        return "EntityInjectionImpl{key=" + String.valueOf(this.key) + ", entityClass=" + this.entityClass.getName() + ", backingType=" + String.valueOf(this.backingType) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EntityInjectionImpl)) {
            return false;
        }
        EntityInjectionImpl that = (EntityInjectionImpl)o;
        return this.key.equals((Object)that.key) && this.entityClass.equals(that.entityClass);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.entityClass.hashCode();
        return result;
    }

    static final class BuilderImpl<T extends net.minecraft.world.entity.Entity, B extends Entity>
    implements EntityInjection.Builder<T, B> {
        private final Key key;
        private final Class<T> entityClass;
        private final EntityType.EntityFactory<T> entityFactory;
        private final ConvertFunction<T, B> convertFunction;
        private final EntityType<?> backingType;
        private final boolean isLivingEntity;
        private MobCategory category = MobCategory.MISC;
        private Consumer<EntityType.Builder<T>> typeBuilder = b -> {};
        private @Nullable AttributeSupplier attributes;
        private Set<UnboundEntityVariant> variants = new LinkedHashSet<UnboundEntityVariant>();
        private Map<Locale, Component> displayNames = new HashMap<Locale, Component>();
        private VariantRule variantRule = VariantRule.first();
        private SpawnRule spawnRule = SpawnRule.never();

        public BuilderImpl(Key key, Class<T> entityClass, EntityType.EntityFactory<T> entityFactory, ConvertFunction<T, B> convertFunction, EntityType<?> backingType) {
            this.key = key;
            this.entityClass = entityClass;
            this.entityFactory = entityFactory;
            this.convertFunction = convertFunction;
            this.backingType = backingType;
            this.isLivingEntity = LivingEntity.class.isAssignableFrom(entityClass);
            this.attributes = this.isLivingEntity ? LivingEntity.createLivingAttributes().build() : null;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Class<T> getEntityClass() {
            return this.entityClass;
        }

        @Override
        public EntityType.EntityFactory<T> getEntityFactory() {
            return this.entityFactory;
        }

        @Override
        public ConvertFunction<T, B> getConvertFunction() {
            return this.convertFunction;
        }

        @Override
        public EntityInjection.Builder<T, B> setMobCategory(MobCategory category) {
            this.category = category;
            return this;
        }

        @Override
        public MobCategory getMobCategory() {
            return this.category;
        }

        @Override
        public EntityInjection.Builder<T, B> setTypeCustomizer(Consumer<EntityType.Builder<T>> typeBuilder) {
            this.typeBuilder = typeBuilder;
            return this;
        }

        @Override
        public Consumer<EntityType.Builder<T>> getTypeCustomizer() {
            return this.typeBuilder;
        }

        @Override
        public EntityInjection.Builder<T, B> setDefaultAttributes(AttributeSupplier attributes) {
            if (!this.isLivingEntity) {
                throw new UnsupportedOperationException("'" + this.entityClass.getName() + "' does not extend '" + LivingEntity.class.getName() + "'. Only living entities can have attributes.");
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public @Nullable AttributeSupplier getDefaultAttributes() {
            return this.attributes;
        }

        @Override
        public EntityInjection.Builder<T, B> addVariant(UnboundEntityVariant variant) {
            this.variants.add(variant);
            return this;
        }

        @Override
        public EntityInjection.Builder<T, B> setVariants(Collection<UnboundEntityVariant> variants) {
            this.variants = new LinkedHashSet<UnboundEntityVariant>(variants);
            return this;
        }

        @Override
        public @Unmodifiable Set<UnboundEntityVariant> getVariants() {
            return Collections.unmodifiableSet(this.variants);
        }

        @Override
        public EntityInjection.Builder<T, B> setVariantRule(VariantRule variantRule) {
            this.variantRule = variantRule;
            return this;
        }

        @Override
        public EntityInjection.Builder<T, B> setDisplayNames(Map<Locale, Component> displayNames) {
            this.displayNames = new HashMap<Locale, Component>(displayNames);
            return this;
        }

        @Override
        public EntityInjection.Builder<T, B> setDisplayName(Locale locale, Component displayName) {
            this.displayNames.put(locale, displayName);
            return this;
        }

        @Override
        public @Unmodifiable Map<Locale, Component> getDisplayNames() {
            return Collections.unmodifiableMap(this.displayNames);
        }

        @Override
        public VariantRule getVariantRule() {
            return this.variantRule;
        }

        @Override
        public EntityInjection.Builder<T, B> setSpawnRule(SpawnRule spawnRule) {
            this.spawnRule = spawnRule;
            return this;
        }

        @Override
        public SpawnRule getSpawnRule() {
            return this.spawnRule;
        }

        @Override
        public EntityInjection<T, B> build() {
            return new EntityInjectionImpl(this);
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof BuilderImpl)) {
                return false;
            }
            BuilderImpl builder = (BuilderImpl)o;
            return this.key.equals((Object)builder.key) && this.entityClass.equals(builder.entityClass);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.entityClass.hashCode();
            return result;
        }

        public String toString() {
            return "EntityInjectionImpl.BuilderImpl{key=" + String.valueOf(this.key) + ", entityClass=" + String.valueOf(this.entityClass) + ", backingType=" + String.valueOf(this.backingType) + "}";
        }
    }
}

