/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject.biome;

import cz.jeme.bestium.api.inject.biome.BiomeFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.DoubleRange;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.jspecify.annotations.Nullable;

final class BiomeFilters {
    private static @Nullable Registry<Biome> lazyBiomeRegistry;
    private static @Nullable Map<Key, TagKey<Biome>> lazyBiomeTags;

    private BiomeFilters() {
        throw new AssertionError();
    }

    public static BiomeFilter and(BiomeFilter ... filters) {
        return biome -> {
            for (BiomeFilter filter : filters) {
                if (filter.test(biome)) continue;
                return false;
            }
            return true;
        };
    }

    public static BiomeFilter or(BiomeFilter ... filters) {
        return biome -> {
            for (BiomeFilter filter : filters) {
                if (!filter.test(biome)) continue;
                return true;
            }
            return false;
        };
    }

    public static BiomeFilter not(BiomeFilter filter) {
        return biome -> !filter.test(biome);
    }

    private static RegistryAccess.Frozen registryAccess() {
        return ((CraftServer)Bukkit.getServer()).getHandle().getServer().registryAccess();
    }

    private static Registry<Biome> biomeRegistry() {
        if (lazyBiomeRegistry == null) {
            lazyBiomeRegistry = BiomeFilters.registryAccess().lookupOrThrow(Registries.BIOME);
        }
        return lazyBiomeRegistry;
    }

    private static Map<Key, TagKey<Biome>> biomeTags() {
        if (lazyBiomeTags == null) {
            lazyBiomeTags = BiomeFilters.biomeRegistry().getTags().map(HolderSet.Named::key).collect(Collectors.toMap(key -> Key.key((String)key.location().toString()), Function.identity(), (k1, k2) -> {
                throw new AssertionError((Object)"Duplicate tag keys encountered");
            }, HashMap::new));
        }
        return lazyBiomeTags;
    }

    public static BiomeFilter tag(Key tagKey) {
        return biome -> {
            ResourceLocation loc = BiomeFilters.biomeRegistry().getKey((Object)biome);
            assert (loc != null);
            return ((Holder.Reference)BiomeFilters.biomeRegistry().get(loc).orElseThrow()).is(BiomeFilters.biomeTags().get(tagKey));
        };
    }

    public static BiomeFilter keys(Set<Key> biomeKeys) {
        return biome -> {
            ResourceLocation loc = BiomeFilters.biomeRegistry().getKey((Object)biome);
            assert (loc != null);
            return biomeKeys.contains(Key.key((String)loc.toString()));
        };
    }

    public static BiomeFilter baseTemperature(DoubleRange temperatureRange) {
        return biome -> temperatureRange.contains((Object)biome.getBaseTemperature());
    }
}

