/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject.variant;

import cz.jeme.bestium.api.inject.biome.BiomeFilter;
import cz.jeme.bestium.api.inject.variant.BoundEntityVariant;
import cz.jeme.bestium.api.inject.variant.EntitySpawnContext;
import cz.jeme.bestium.api.inject.variant.VariantRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.apache.commons.lang3.DoubleRange;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.entity.Entity;

final class VariantRules {
    public static final VariantRule NONE = (variants, ctx) -> null;
    public static final VariantRule FIRST = (variants, ctx) -> {
        Iterator it = variants.values().iterator();
        return it.hasNext() ? (BoundEntityVariant)it.next() : null;
    };
    public static final VariantRule RANDOM = (variants, ctx) -> {
        if (variants.isEmpty()) {
            return null;
        }
        if (variants.size() == 1) {
            return (BoundEntityVariant)variants.values().iterator().next();
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(variants.size());
        int i = 0;
        for (BoundEntityVariant variant : variants.values()) {
            if (i == randomIndex) {
                return variant;
            }
            ++i;
        }
        throw new AssertionError();
    };

    private VariantRules() {
        throw new AssertionError();
    }

    private static IllegalArgumentException unknownVariant(Map<String, BoundEntityVariant> variants, EntitySpawnContext ctx, String ... unknownIds) {
        boolean single = unknownIds.length == 1;
        return new IllegalArgumentException("Unknown variant" + (single ? "" : "s") + ": " + (single ? "'" : "[") + String.join((CharSequence)", ", unknownIds) + (single ? "'" : "]") + " for entity '" + String.valueOf(ctx.getInjection().getRealType()) + "'. Known variants: [" + String.join((CharSequence)", ", variants.keySet()) + "]");
    }

    public static VariantRule always(@KeyPattern.Namespace String variantId) {
        return (variants, ctx) -> {
            BoundEntityVariant variant = (BoundEntityVariant)variants.get(variantId);
            if (variant == null) {
                throw VariantRules.unknownVariant(variants, ctx, variantId);
            }
            return variant;
        };
    }

    public static VariantRule weighted(Map<String, Integer> weights) {
        if (weights.isEmpty()) {
            throw new IllegalArgumentException("Weights map must not be empty");
        }
        ArrayList<String> weightedList = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : weights.entrySet()) {
            String variantId = entry.getKey();
            int value = entry.getValue();
            if (value <= 0) continue;
            for (int i = 0; i < value; ++i) {
                weightedList.add(variantId);
            }
        }
        int size = weightedList.size();
        return (variants, ctx) -> {
            if (variants.isEmpty()) {
                throw VariantRules.unknownVariant(variants, ctx, (String[])weights.keySet().toArray(String[]::new));
            }
            int randomIndex = ThreadLocalRandom.current().nextInt(size);
            String variantId = (String)weightedList.get(randomIndex);
            BoundEntityVariant variant = (BoundEntityVariant)variants.get(variantId);
            if (variant == null) {
                throw VariantRules.unknownVariant(variants, ctx, variantId);
            }
            return variant;
        };
    }

    public static VariantRule ifBiome(BiomeFilter filter, @KeyPattern.Namespace String variantId) {
        return (variants, ctx) -> {
            if (!variants.containsKey(variantId)) {
                throw VariantRules.unknownVariant(variants, ctx, variantId);
            }
            Entity entity = ctx.getEntity();
            Biome bukkitBiome = entity.getWorld().getBiome(entity.getLocation());
            net.minecraft.world.level.biome.Biome biome = (net.minecraft.world.level.biome.Biome)((CraftBiome)bukkitBiome).getHandle();
            return filter.test(biome) ? (BoundEntityVariant)variants.get(variantId) : null;
        };
    }

    public static VariantRule ifWorlds(Set<Key> worldKeys, @KeyPattern.Namespace String variantId) {
        return (variants, ctx) -> {
            if (!variants.containsKey(variantId)) {
                throw VariantRules.unknownVariant(variants, ctx, variantId);
            }
            NamespacedKey currentWorldKey = ctx.getEntity().getLocation().getWorld().getKey();
            return worldKeys.contains(currentWorldKey) ? (BoundEntityVariant)variants.get(variantId) : null;
        };
    }

    public static VariantRule ifTemperature(DoubleRange temperatureRange, @KeyPattern.Namespace String variantId) {
        return (variants, ctx) -> {
            if (!variants.containsKey(variantId)) {
                throw VariantRules.unknownVariant(variants, ctx, variantId);
            }
            Location location = ctx.getEntity().getLocation();
            double temperature = location.getWorld().getTemperature(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            return temperatureRange.contains((Object)temperature) ? (BoundEntityVariant)variants.get(variantId) : null;
        };
    }

    public static VariantRule firstMatch(VariantRule ... rules) {
        return (variants, ctx) -> {
            for (VariantRule rule : rules) {
                BoundEntityVariant variant = rule.apply(variants, ctx);
                if (variant == null) continue;
                return variant;
            }
            return null;
        };
    }
}

