/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject.variant;

import cz.jeme.bestium.api.inject.variant.AbstractEntityVariant;
import cz.jeme.bestium.api.inject.variant.BoundEntityVariant;
import cz.jeme.bestium.api.inject.variant.UnboundEntityVariant;
import cz.jeme.bestium.api.inject.variant.UnboundEntityVariantImpl;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.kyori.adventure.key.KeyPattern;

public sealed interface EntityVariant
permits AbstractEntityVariant, UnboundEntityVariant, BoundEntityVariant {
    public static UnboundEntityVariant fromModelUrl(@KeyPattern.Namespace String id, URL modelUrl) {
        return new UnboundEntityVariantImpl(id, modelUrl);
    }

    public static UnboundEntityVariant fromModelFile(@KeyPattern.Namespace String id, File modelFile) {
        try {
            return EntityVariant.fromModelUrl(id, modelFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Given model file has invalid URL: '" + modelFile.getAbsolutePath() + "'", e);
        }
    }

    public static UnboundEntityVariant fromModelResource(@KeyPattern.Namespace String id, PluginBootstrap bootstrapper, String resourceName) {
        URL url = bootstrapper.getClass().getClassLoader().getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException("Entity model resource not found: '" + resourceName + "'");
        }
        return EntityVariant.fromModelUrl(id, url);
    }

    @KeyPattern.Namespace
    public String getId();

    public URL getModelUrl();
}

