/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api;

import cz.jeme.bestium.api.Bestium;
import cz.jeme.bestium.api.inject.EntityInjection;
import java.util.function.Consumer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EntityManager {
    public static EntityManager getManager() {
        return Bestium.getEntityManager();
    }

    default public boolean isInjected(Entity entity) {
        return this.isInjected(((CraftEntity)entity).getHandle());
    }

    default public boolean isInjected(net.minecraft.world.entity.Entity entity) {
        return this.isInjected(entity.getType());
    }

    public boolean isInjected(EntityType<?> var1);

    default public @Nullable EntityInjection<?, ?> getInjection(Entity entity) {
        return this.getInjection(((CraftEntity)entity).getHandle());
    }

    public @Nullable EntityInjection<?, ?> getInjection(net.minecraft.world.entity.Entity var1);

    default public EntityInjection<?, ?> requireInjection(Entity entity) {
        return this.requireInjection(((CraftEntity)entity).getHandle());
    }

    default public EntityInjection<?, ?> requireInjection(net.minecraft.world.entity.Entity entity) {
        EntityInjection<?, ?> injection = this.getInjection(entity);
        if (injection == null) {
            throw new IllegalArgumentException("The provided entity is not an injected entity: '" + entity.getClass().getName() + "'");
        }
        return injection;
    }

    public <T extends net.minecraft.world.entity.Entity> @Nullable T spawn(Location var1, Class<T> var2, EntitySpawnReason var3, CreatureSpawnEvent.SpawnReason var4, Consumer<T> var5);

    default public <T extends net.minecraft.world.entity.Entity> @Nullable T spawn(Location location, Class<T> entityClass, EntitySpawnReason entitySpawnReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.spawn(location, entityClass, entitySpawnReason, creatureSpawnReason, entity -> {});
    }

    public @Nullable EntityType<?> getBackingType(EntityType<?> var1);

    default public @Nullable EntityType<?> getBackingType(net.minecraft.world.entity.Entity entity) {
        return this.getBackingType(entity.getType());
    }

    default public @Nullable EntityType<?> getBackingType(Entity entity) {
        return this.getBackingType(((CraftEntity)entity).getHandle());
    }
}

