/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject;

import cz.jeme.bestium.api.Bestium;
import cz.jeme.bestium.api.inject.EntityInjection;
import java.util.Map;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface EntityInjector {
    public static EntityInjector injector() {
        return Bestium.getInjector();
    }

    public void register(Supplier<EntityInjection<?, ?>> var1);

    public @Unmodifiable Map<Class<? extends Entity>, EntityInjection<?, ?>> getInjections();

    @Nullable
    default public <T extends Entity> EntityInjection<T, ?> getInjection(Class<T> entityClass) {
        return this.getInjections().get(entityClass);
    }

    public @Unmodifiable Map<Key, EntityInjection<?, ?>> getKeyedInjections();

    public @Unmodifiable Map<Class<? extends Entity>, EntityType<?>> getTypes();

    @Nullable
    default public <T extends Entity> EntityType<T> getType(Class<T> entityClass) {
        return this.getTypes().get(entityClass);
    }

    public @Unmodifiable Map<Key, EntityType<?>> getKeyedTypes();

    public Phase getPhase();

    default public boolean canRegister() {
        return this.getPhase() == Phase.REGISTRATION;
    }

    public static enum Phase {
        REGISTRATION,
        PRE_INJECTION,
        INJECTION_PHASE_1,
        INJECTION_PHASE_2,
        INJECTED;

    }
}

