/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject.biome;

import cz.jeme.bestium.api.inject.biome.BiomeFilters;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.DoubleRange;

@FunctionalInterface
public interface BiomeFilter {
    public boolean test(Biome var1);

    public static BiomeFilter and(BiomeFilter ... filters) {
        return BiomeFilters.and(filters);
    }

    public static BiomeFilter or(BiomeFilter ... filters) {
        return BiomeFilters.or(filters);
    }

    public static BiomeFilter not(BiomeFilter filter) {
        return BiomeFilters.not(filter);
    }

    public static BiomeFilter baseTemperature(DoubleRange temperatureRange) {
        return BiomeFilters.baseTemperature(temperatureRange);
    }

    public static BiomeFilter tag(Key tagKey) {
        return BiomeFilters.tag(tagKey);
    }

    public static BiomeFilter key(Key biomeKey) {
        return BiomeFilter.keys(Set.of(biomeKey));
    }

    public static BiomeFilter keys(Set<Key> biomeKeys) {
        return BiomeFilters.keys(biomeKeys);
    }

    public static BiomeFilter keys(Key first, Key second, Key ... rest) {
        HashSet<Key> biomeKeys = new HashSet<Key>();
        biomeKeys.add(first);
        biomeKeys.add(second);
        Collections.addAll(biomeKeys, rest);
        return BiomeFilter.keys(biomeKeys);
    }

    public static BiomeFilter overworld() {
        return BiomeFilter.tag(Key.key((String)"minecraft:is_overworld"));
    }

    public static BiomeFilter nether() {
        return BiomeFilter.tag(Key.key((String)"minecraft:is_nether"));
    }

    public static BiomeFilter end() {
        return BiomeFilter.tag(Key.key((String)"minecraft:is_end"));
    }
}

