/*
 * Decompiled with CFR 0.152.
 */
package cz.jeme.bestium.api.inject.variant;

import cz.jeme.bestium.api.inject.biome.BiomeFilter;
import cz.jeme.bestium.api.inject.variant.BoundEntityVariant;
import cz.jeme.bestium.api.inject.variant.EntitySpawnContext;
import cz.jeme.bestium.api.inject.variant.VariantRules;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.apache.commons.lang3.DoubleRange;
import org.checkerframework.checker.index.qual.Positive;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface VariantRule {
    public @Nullable BoundEntityVariant apply(@Unmodifiable Map<String, BoundEntityVariant> var1, EntitySpawnContext var2);

    public static VariantRule first() {
        return VariantRules.FIRST;
    }

    public static VariantRule random() {
        return VariantRules.RANDOM;
    }

    public static VariantRule weighted(Map<String, @Positive Integer> weights) {
        return VariantRules.weighted(weights);
    }

    public static VariantRule none() {
        return VariantRules.NONE;
    }

    public static VariantRule always(@KeyPattern.Namespace String variantId) {
        return VariantRules.always(variantId);
    }

    public static VariantRule ifBiome(BiomeFilter filter, @KeyPattern.Namespace String variantId) {
        return VariantRules.ifBiome(filter, variantId);
    }

    public static VariantRule ifWorld(Key worldKey, @KeyPattern.Namespace String variantId) {
        return VariantRule.ifWorlds(Set.of(worldKey), variantId);
    }

    public static VariantRule ifWorlds(Set<Key> worldKeys, @KeyPattern.Namespace String variantId) {
        return VariantRules.ifWorlds(worldKeys, variantId);
    }

    public static VariantRule ifTemperature(DoubleRange temperatureRange, @KeyPattern.Namespace String variantId) {
        return VariantRules.ifTemperature(temperatureRange, variantId);
    }

    public static VariantRule firstMatch(VariantRule ... rules) {
        return VariantRules.firstMatch(rules);
    }
}

