/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.HttpClientUtil;
import cz.jiripinkas.jsitemapgenerator.W3CDateFormat;
import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.GWTException;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSitemapGenerator {
    private Map<String, WebPage> urls = new TreeMap<String, WebPage>();
    private String baseUrl;
    private static final Logger logger = LoggerFactory.getLogger(WebSitemapGenerator.class);
    private W3CDateFormat dateFormat = new W3CDateFormat();

    public WebSitemapGenerator(String baseUrl) {
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public void addPage(WebPage webPage) {
        this.urls.put(this.baseUrl + webPage.getName(), webPage);
    }

    public void addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
    }

    public String[] constructSitemap() {
        ArrayList<String> out = new ArrayList<String>();
        out.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.add("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
        Collection<WebPage> values = this.urls.values();
        for (WebPage webSitemapUrl : values) {
            out.add(webSitemapUrl.constructUrl(this.dateFormat, this.baseUrl));
        }
        out.add("</urlset>");
        return out.toArray(new String[0]);
    }

    public void saveSitemap(File file, String[] sitemap) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        for (String string : sitemap) {
            writer.write(string);
        }
        writer.close();
    }

    public void constructAndSaveSitemap(File file) throws IOException {
        String[] sitemap = this.constructSitemap();
        this.saveSitemap(file, sitemap);
    }

    public void pingGoogle(String sitemapUrl) {
        try {
            String pingUrl = "http://www.google.com/webmasters/tools/ping?sitemap=" + URLEncoder.encode(sitemapUrl, "UTF-8");
            logger.debug("Will ping this URL: " + pingUrl);
            int returnCode = HttpClientUtil.get(pingUrl);
            if (returnCode != 200) {
                throw new GWTException("Google could not be informed about new sitemap!");
            }
        }
        catch (Exception ex) {
            throw new GWTException("Google could not be informed about new sitemap!");
        }
    }

    public void pingGoogle() {
        this.pingGoogle(this.baseUrl + "sitemap.xml");
    }
}

