/*
 * Decompiled with CFR 0.152.
 */
package cz.jiripinkas.jsitemapgenerator;

import cz.jiripinkas.jsitemapgenerator.WebPage;
import cz.jiripinkas.jsitemapgenerator.exception.InvalidUrlException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerator {
    protected Map<String, WebPage> urls = new TreeMap<String, WebPage>();
    protected String baseUrl;

    public AbstractGenerator(String baseUrl) {
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidUrlException(e);
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
    }

    public void addPage(WebPage webPage) {
        this.urls.put(this.baseUrl + webPage.getName(), webPage);
    }

    public void addPages(Collection<WebPage> webPages) {
        for (WebPage webPage : webPages) {
            this.addPage(webPage);
        }
    }
}

